% Generated by roxygen2 (4.0.0): do not edit by hand
\name{lookup_e}
\alias{\%le+\%}
\alias{\%le\%}
\alias{lookup_e}
\alias{lookup_e.character}
\alias{lookup_e.data.frame}
\alias{lookup_e.factor}
\alias{lookup_e.list}
\alias{lookup_e.matrix}
\alias{lookup_e.numeric}
\title{Hash Table/Dictionary Lookup}
\usage{
lookup_e(terms, key.match, key.reassign = NULL, missing = NA)

\method{lookup_e}{matrix}(terms, key.match, key.reassign = NULL,
  missing = NA)

\method{lookup_e}{data.frame}(terms, key.match, key.reassign = NULL,
  missing = NA)

\method{lookup_e}{list}(terms, key.match, key.reassign = NULL, missing = NA)

\method{lookup_e}{numeric}(terms, key.match, key.reassign = NULL,
  missing = NA)

\method{lookup_e}{factor}(terms, key.match, key.reassign = NULL,
  missing = NA)

\method{lookup_e}{character}(terms, key.match, key.reassign = NULL,
  missing = NA)

terms \%le\% key.match

terms \%le+\% key.match
}
\arguments{
\item{terms}{A vector of terms to undergo a lookup_e.}

\item{key.match}{Takes one of the following: (1) a two column data.frame of a
match key and reassignment column, (2) a named list of vectors (Note: if
data.frame or named list supplied no key reassign needed) or (3) a single
vector match key.}

\item{key.reassign}{A single reassignment vector supplied if key.match is
not a two column data.frame/named list.}

\item{missing}{Value to assign to terms not matching the key.match.  If set
to \code{NULL} the original values in \code{terms} corresponding to the
missing elements are retained.}
}
\value{
Outputs A new vector with reassigned values.
}
\description{
\code{lookup_e} - Environment based hash table useful for large vector lookups.

\code{\%le\%} - A binary operator version of \code{lookup_e}
for when \code{key.match} is a data.frame or named list.

\code{\%le+\%} - A binary operator version of \code{lookup_e}
for when \code{key.match} is a data.frame or named list and \code{missing} is
assumed to be \code{NULL}.
}
\examples{
lookup_e(1:5, data.frame(1:4, 11:14))

## Retain original values for missing
lookup_e(1:5, data.frame(1:4, 11:14), missing=NULL)

lookup_e(LETTERS[1:5], data.frame(LETTERS[1:5], 100:104))
lookup_e(LETTERS[1:5], factor(LETTERS[1:5]), 100:104)

## Supply a named list of vectors to key.match

codes <- list(
    A = c(1, 2, 4),
    B = c(3, 5),
    C = 7,
    D = c(6, 8:10)
)

lookup_e(1:10, codes)

## Supply a single vector to key.match and key.reassign

lookup_e(mtcars$carb, sort(unique(mtcars$carb)),
    c("one", "two", "three", "four", "six", "eight"))

lookup_e(mtcars$carb, sort(unique(mtcars$carb)),
    seq(10, 60, by=10))

## \%le\%, a binary operator version of lookup
1:5 \%le\% data.frame(1:4, 11:14)
1:10 \%le\% codes

1:12 \%le\% codes
1:12 \%le+\% codes
}
\seealso{
\code{\link[base]{new.env}}, \code{\link[qdapTools]{lookup}},
}
\keyword{dictionary,}
\keyword{hash,}
\keyword{lookup}

