% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_calcweights.R
\name{getstratweights}
\alias{getstratweights}
\title{Calculate weights at a set value of effect measure modifier}
\usage{
getstratweights(x, emmval = 1, ...)
}
\arguments{
\item{x}{"qgcompemmfit" object from qgcomp.emm.noboot
function}

\item{emmval}{numerical: value of effect measure modifier at which weights are generated}

\item{...}{unused}
}
\value{
An object of class "qgcompemmweights", which is just a special R list

This class contains the \code{emmval}-stratum specific weights of components of the mixture. By default, this prints a list of "weights", similar to objects of type "qgcompemmfit" which displays the stratum specific weights from a "qgcompemmfit" model (if it is run without bootstrapping).
}
\description{
A standard qgcomp fit with effect measure modification
only estimates weights at the referent (0) level of the modifier.
This function can be used to estimate weights at arbitrary levels of the modifier
}
\examples{
set.seed(1231)
dat <- data.frame(y=runif(50), x1=runif(50), x2=runif(50),
  z=rbinom(50,1,0.5), r=rbinom(50,1,0.5))
(qfit <- qgcomp.emm.noboot(f=y ~ z + x1 + x2, emmvar="z",
  expnms = c('x1', 'x2'), data=dat, q=2, family=gaussian()))
getstratweights(qfit, emmval = 0)
weights1 = getstratweights(qfit, emmval = 1)
weights1$pos.weights
}
\seealso{
\code{\link[qgcompint]{qgcomp.emm.noboot}}
}
\concept{variance mixtures}
