% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRho.R
\name{getRho}
\alias{getRho}
\title{Extract estimates of the intra-class correlation from a glmmTMB
model object with beta-binomial error.}
\usage{
getRho(obj, varMult = FALSE)
}
\arguments{
\item{obj}{\pkg{glmmTMB} model object with betabinomial error,
and with a `dispformula` argument supplied.}

\item{varMult}{If \code{TRUE} return, in addition to \code{rho},
the factor \code{mult} by which the variance is inflated
relative to the binomial.}
}
\value{
if \code{varMult==FALSE} return (as a vector) the estimates
\eqn{\rho}, else (\code{varMult==TRUE})  return
\code{list(rho, mult)}.
}
\description{
The intra-class correlation is calculated as
  \eqn{(1+exp(\theta))^{-1}}, where \eqn{\theta} is the
  estimate given by the formula specified in the argument
  \code{dispformula}.
}
\details{
The variance for the betabinomial model is then
obtained by multiplying the binomial variance by
\eqn{1+(n-1)\rho}, where $n$ is the binomial `size`.
}
\examples{
form <- cbind(dead,total-dead)~0+Cultivar/dose+(1|cultRep)
codling1989.TMB <- glmmTMB::glmmTMB(formula=form,
  family=glmmTMB::betabinomial(link='cloglog'),
  dispformula=~0+Cultivar/splines::ns(dose,2), data=qra::codling1989)
rho <- getRho(codling1989.TMB)
}
