% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_svg.R
\name{generate_svg}
\alias{generate_svg}
\title{Generate the QR code as an svg file}
\usage{
generate_svg(
  qrcode,
  filename,
  size = 100,
  foreground = "black",
  background = "white",
  show = interactive()
)
}
\arguments{
\item{qrcode}{a \code{qr_code} object as generated by \code{qr_code}.}

\item{filename}{Where to store the filename.
Silently overwrites existing files.
Tries to create the path, when it doesn't exist.}

\item{size}{size of the svg file in pixels.}

\item{foreground}{Stroke and fill colour for the foreground.
Use a valid \href{https://www.w3schools.com/colors/}{CSS colour}.
Defaults to \code{"black"}.}

\item{background}{Fill colour for the background.
Use a valid \href{https://www.w3schools.com/colors/}{CSS colour}.
Defaults to \code{"white"}.}

\item{show}{Open the file after creating it.
Defaults to \code{TRUE} on \code{\link[=interactive]{interactive()}} sessions, otherwise \code{FALSE}.}
}
\value{
invisible \code{NULL}
}
\description{
Create the QR code using \code{\link[=qr_code]{qr_code()}} and save it as an svg file.
}
\examples{
code <- qr_code("HELLO WORLD")
generate_svg(
  qrcode = code, filename = tempfile(fileext = ".svg"), show = FALSE
)
}
\seealso{
Other qr: 
\code{\link{plot.qr_code}()},
\code{\link{print.qr_code}()},
\code{\link{qr_code}()}
}
\author{
Thierry Onkelinx
}
\concept{qr}
