\name{plot.errorlod}
\alias{plot.errorlod}

\title{Plot grid of error LOD values}

\description{
  Plot a grid of the LOD scores indicating which genotypes are
  likely to be in error.
}

\usage{
plot.errorlod(x, chr, ind, breaks=c(-Inf,2,3,4.5,Inf),
              col=c("white","gray85","hotpink","purple3"),
              alternate.chrid=FALSE, \dots)
}

\arguments{
  \item{x}{An object of class \code{cross}.  See
    \code{\link[qtl]{read.cross}} for details.}
  \item{chr}{The chromosomes for which the error LOD scores should
    be plotted.}
  \item{ind}{Indicates the individuals for which the error LOD scores
    should be plotted.}
  \item{breaks}{A set of breakpoints for the colors; must give one more
    breakpoint than color.  Intervals are open on the left and closed on
    the right, except for the lowest interval.}
  \item{col}{A vector of colors to appear in the image.}
  \item{alternate.chrid}{If TRUE and more than one chromosome is
    plotted, alternate the placement of chromosome 
     axis labels, so that they may be more easily distinguished.}
  \item{\dots}{Ignored at this point.}
}

\details{
  Uses \code{\link[graphics]{image}} to plot a grid with different shades
  of pixels to indicate which genotypes are likely to be in error.

  Darker pixels have higher error LOD scores:
  \eqn{LOD \le 2} in white;
  \eqn{2 < LOD \le 3}{2 < LOD <= 3} in gray;
  \eqn{3 < LOD \le 4.5}{3 < LOD <= 4.5} in pink;
  \eqn{LOD > 4.5} in purple.
}

\value{None.}

\examples{
data(hyper)
\dontshow{hyper <- subset(hyper,chr=c(1,19))}
# Calculate error LOD scores
hyper <- calc.errorlod(hyper,error.prob=0.01)

# plot the error LOD scores; print those above a specified cutoff 
plot.errorlod(hyper)
plot.errorlod(hyper,chr=1)
}

\seealso{ \code{\link[qtl]{calc.errorlod}},
  \code{\link[qtl]{top.errorlod}}, \code{\link[graphics]{image}} }

\references{
  Lincoln, S. E. and Lander, E. S. (1992) Systematic detection of
  errors in genetic linkage data.  \emph{Genomics} \bold{14}, 604--610.
}

\author{Karl W Broman, \email{kbroman@biostat.wisc.edu} }

\keyword{hplot}
