% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_geno.R
\name{sim_geno}
\alias{sim_geno}
\title{Simulate genotypes given observed marker data}
\usage{
sim_geno(
  cross,
  map = NULL,
  n_draws = 1,
  error_prob = 0.0001,
  map_function = c("haldane", "kosambi", "c-f", "morgan"),
  lowmem = FALSE,
  quiet = TRUE,
  cores = 1
)
}
\arguments{
\item{cross}{Object of class \code{"cross2"}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}.}

\item{map}{Genetic map of markers. May include pseudomarker
locations (that is, locations that are not within the marker
genotype data). If NULL, the genetic map in \code{cross} is used.}

\item{n_draws}{Number of simulations to perform.}

\item{error_prob}{Assumed genotyping error probability}

\item{map_function}{Character string indicating the map function to
use to convert genetic distances to recombination fractions.}

\item{lowmem}{If \code{FALSE}, split individuals into groups with
common sex and crossinfo and then precalculate the transition
matrices for a chromosome; potentially a lot faster but using more
memory.}

\item{quiet}{If \code{FALSE}, print progress messages.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}
}
\value{
An object of class \code{"sim_geno"}: a list of three-dimensional arrays of imputed genotypes,
individuals x positions x draws. Also contains three attributes:
\itemize{
\item \code{crosstype} - The cross type of the input \code{cross}.
\item \code{is_x_chr} - Logical vector indicating whether chromosomes
are to be treated as the X chromosome or not, from input \code{cross}.
\item \code{alleles} - Vector of allele codes, from input
\code{cross}.
}
}
\description{
Uses a hidden Markov model to simulate from the joint distribution
Pr(g | O) where g is the underlying sequence of true genotypes and
O is the observed multipoint marker data, with possible allowance
for genotyping errors.
}
\details{
After performing the backward equations, we draw from
\eqn{Pr(g_1 = v | O)}{Pr(g[1] = v | O)} and then \eqn{Pr(g_{k+1} = v |
   O, g_k = u)}{Pr(g[k+1] = v | O, g[k] = u)}.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
map_w_pmar <- insert_pseudomarkers(grav2$gmap, step=1)
draws <- sim_geno(grav2, map_w_pmar, n_draws=4, error_prob=0.002)
}
\seealso{
\code{\link[=cbind.sim_geno]{cbind.sim_geno()}}, \code{\link[=rbind.sim_geno]{rbind.sim_geno()}}
}
\keyword{utilities}
