% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_geno.R
\name{summary_compare_geno}
\alias{summary_compare_geno}
\alias{summary.compare_geno}
\alias{print.summary.compare_geno}
\title{Basic summary of compare_geno object}
\usage{
summary_compare_geno(object, threshold = 0.9, ...)

\method{summary}{compare_geno}(object, threshold = 0.9, ...)

\method{print}{summary.compare_geno}(x, digits = 2, ...)
}
\arguments{
\item{object}{A square matrix with genotype comparisons for pairs
of individuals, as output by \code{\link[=compare_geno]{compare_geno()}}.}

\item{threshold}{Minimum proportion matches for a pair of individuals to be shown.}

\item{...}{Ignored}

\item{x}{Results of \code{\link[=summary.compare_geno]{summary.compare_geno()}}}

\item{digits}{Number of digits to print}
}
\value{
Data frame with names of individuals in pair, proportion
matches, number of mismatches, number of matches, and total
markers genotyped. Last two columns are the numeric indexes of
the individuals in the pair.
}
\description{
From results of \code{\link[=compare_geno]{compare_geno()}}, show pairs of individuals with similar genotypes.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
cg <- compare_geno(grav2)
summary(cg)
}
\keyword{utilities}
