% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_raw_summaries.R
\name{calc_raw_founder_maf}
\alias{calc_raw_founder_maf}
\title{Calculate founder minor allele frequencies from raw SNP genotypes}
\usage{
calc_raw_founder_maf(cross, by = c("individual", "marker"))
}
\arguments{
\item{cross}{Object of class \code{"cross2"}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}.}

\item{by}{Indicates whether to summarize by founder strain (\code{"individual"}) or by marker.}
}
\value{
A vector of minor allele frequencies, one for each founder strain or marker.
}
\description{
Calculate minor allele frequency from raw SNP genotypes in founders, by founder strain or by marker
}
\examples{
\dontrun{
# load example data and calculate genotype probabilities
file <- paste0("https://raw.githubusercontent.com/rqtl/",
               "qtl2data/main/DOex/DOex.zip")
DOex <- read_cross2(file)
DOex_maf <- calc_raw_founder_maf(DOex)
}
}
\seealso{
\code{\link[=recode_snps]{recode_snps()}}, \code{\link[=calc_raw_maf]{calc_raw_maf()}}
}
\keyword{utilities}
