% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_raw_summaries.R
\name{calc_raw_geno_freq}
\alias{calc_raw_geno_freq}
\title{Calculate genotype frequencies from raw SNP genotypes}
\usage{
calc_raw_geno_freq(cross, by = c("individual", "marker"), cores = 1)
}
\arguments{
\item{cross}{Object of class \code{"cross2"}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}.}

\item{by}{Indicates whether to summarize by individual or by marker.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}
}
\value{
A matrix of genotypes frequencies with 3 columns (AA, AB,
and BB) and with rows being either individuals or markers.
}
\description{
Calculate genotype frequencies from raw SNP genotypes, by individual or by marker
}
\examples{
\dontrun{
# load example data and calculate genotype probabilities
file <- paste0("https://raw.githubusercontent.com/rqtl/",
               "qtl2data/main/DOex/DOex.zip")
DOex <- read_cross2(file)
gfreq <- calc_raw_geno_freq(DOex)
}
}
\seealso{
\code{\link[=calc_raw_maf]{calc_raw_maf()}}, \code{\link[=calc_raw_het]{calc_raw_het()}}, \code{\link[=recode_snps]{recode_snps()}}, \code{\link[=calc_geno_freq]{calc_geno_freq()}}
}
\keyword{utilities}
