% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructHeader.R
\name{constructHeader}
\alias{constructHeader}
\title{Construct a header to send to qualtrics API}
\usage{
constructHeader(API.TOKEN)
}
\arguments{
\item{API.TOKEN}{API token. Available in your qualtrics account (see: \url{https://api.qualtrics.com/docs/authentication})}
}
\description{
Construct a header to send to qualtrics API
}
\examples{
\dontrun{
head <- constructHeader("<YOUR-API-KEY-HERE>")
surveys <- getSurveys(head,
                      "https://leidenuniv.eu.qualtrics.com/API/v3/responseexports/")
                      # URL is for my own institution.
                      # Substitute with your own institution's url
mysurvey <- getSurvey(surveys$id[6],
                      head,
                      "https://leidenuniv.eu.qualtrics.com/API/v3/responseexports/",
                      verbose=TRUE)
}
}
\author{
Jasper Ginn
}
\seealso{
See \url{https://api.qualtrics.com/docs/root-url} for documentation on the Qualtrics API.
}

