% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/functions.R
\name{HREL}
\alias{HREL}
\title{HREL}
\usage{
HREL(x, na.rm = TRUE)
}
\arguments{
\item{x}{a vector of frequencies}

\item{na.rm}{if TRUE, missing values are removed. If FALSE, NA is returned if there is any NA value.}
}
\value{
The value of the HREL statistics, which is normalised (varies between
  0 and 1).
}
\description{
Computes the HREL index for a vector of frequencies of categories.
}
\details{
According to Wilcox (1973, p. 329), and following Senders (1958), the HREL is 'a measure originally developed by engineers for use in specifying the properties of communications channels. The rationale for HREL is presented in terms of guessing by Virginia Senders (supplementing the mode as best guess): "What we need is a measure of uncertainty, or of 'poorness of a guess,' which will be high when the number of alternative possibilities is high, and low when some ofthe possibilities are much more likely than others. One possible measure is the average number of questions we have to ask to specify the correct alternative'. The formula for the HREL is:
\deqn{- \frac{\sum_{i=1}^k \frac{f_i}{N} \log_2 \frac{f_i}{N}}{\log_2 K}}
}
\examples{
x <- rmultinom(1, 100, rep_len(0.25, 4))
x <- as.vector(t(x))
HREL(x)

df <- rmultinom(10, 100, rep_len(0.25, 4))
df <- as.data.frame(t(df))
apply(df, 1, HREL)
}
\references{
Wilcox, Allen R. 'Indices of Qualitative Variation and Political
  Measurement.' \emph{The Western Political Quarterly} 26, no. 2 (1 June
  1973): 325-43. doi:10.2307/446831.
  Senders, Virginia L. Measurement and Statistics. New York: Oxford University Press, 1958.
}

