% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/textmodel-wordfish.R
\docType{methods}
\name{textmodel_wordfish}
\alias{print.textmodel_wordfish_fitted}
\alias{show,textmodel_wordfish_fitted-method}
\alias{show,textmodel_wordfish_predicted-method}
\alias{textmodel_wordfish}
\title{wordfish text model}
\usage{
textmodel_wordfish(data, dir = c(1, 2), priors = c(Inf, Inf, 3, 1),
  tol = c(1e-06, 1e-08), dispersion = "poisson")

\method{print}{textmodel_wordfish_fitted}(x, n = 30L, ...)

\S4method{show}{textmodel_wordfish_fitted}(object)

\S4method{show}{textmodel_wordfish_predicted}(object)
}
\arguments{
\item{data}{the dfm on which the model will be fit}

\item{dir}{set global identification by specifying the indexes for a pair of
documents such that \eqn{\hat{\theta}_{dir[1]} < \hat{\theta}_{dir[2]}}.}

\item{priors}{priors for \eqn{\theta_i}, \eqn{\alpha_i}, \eqn{\psi_j}, and
\eqn{\beta_j} where \eqn{i} indexes documents and \eqn{j} indexes features}

\item{tol}{tolerances for convergence (explain why a pair)}

\item{dispersion}{sets whether a quasi-poisson quasi-likelihood should be used based on a single
dispersion parameter ("single"), dispersion parameters for each work ("byterm" or "bytermfloor"), or not ("none")}

\item{x}{for print method, the object to be printed}

\item{n}{max rows of dfm to print}

\item{...}{additional arguments passed to other functions}

\item{object}{wordfish fitted or predicted object to be shown}
}
\value{
An object of class textmodel_fitted_wordfish.  This is a list
  containing: \item{dir}{global identification of the dimension}
  \item{theta}{estimated document positions} \item{alpha}{estimated document
  fixed effects} \item{beta}{estimated feature marginal effects}
  \item{psi}{estimated word fixed effects} \item{docs}{document labels}
  \item{features}{feature labels} \item{sigma}{regularization parameter for
  betas in Poisson form} \item{ll}{log likelihood at convergence}
  \item{se.theta}{standard errors for theta-hats} \item{data}{dfm to which
  the model was fit}
}
\description{
Estimate Slapin and Proksch's (2008) "wordfish" Poisson scaling model of
one-dimensional document positions using conditional maximum likelihood.
}
\details{
The returns match those of Will Lowe's R implementation of
  \code{wordfish} (see the austin package), except that here we have renamed \code{words} to
  be \code{features}.  (This return list may change.)  We have also followed the practice begun with
  Slapin and Proksch's early implementation of the model that used a regularization parameter of
  se\eqn{(\sigma) = 3}, through the third element in \code{priors}.
}
\examples{
ie2010dfm <- dfm(ie2010Corpus, verbose=FALSE)
wfmodel <- textmodel_wordfish(LBGexample, dir = c(6,5))
wfmodel

\dontrun{if (require(austin)) {
        wfmodelAustin <- wordfish(quanteda::as.wfm(LBGexample), dir = c(6,5))
        cor(wfmodel@theta, wfmodelAustin$theta)
}}
}
\author{
Benjamin Lauderdale and Kenneth Benoit
}
\references{
Jonathan Slapin and Sven-Oliver Proksch.  2008. "A Scaling Model
  for Estimating Time-Series Party Positions from Texts." \emph{American
  Journal of Political Science} 52(3):705-772.
}

