% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm-classes.R, R/dfm-subsetting.R
\docType{class}
\name{dfm-class}
\alias{dfm-class}
\alias{dfmSparse-class}
\alias{t,dfm-method}
\alias{colSums,dfm-method}
\alias{rowSums,dfm-method}
\alias{colMeans,dfm-method}
\alias{rowMeans,dfm-method}
\alias{Arith,dfm,numeric-method}
\alias{Arith,numeric,dfm-method}
\alias{[,dfm,index,index,missing-method}
\alias{[,dfm,index,index,logical-method}
\alias{[,dfm,missing,missing,missing-method}
\alias{[,dfm,missing,missing,logical-method}
\alias{[,dfm,index,missing,missing-method}
\alias{[,dfm,index,missing,logical-method}
\alias{[,dfm,missing,index,missing-method}
\alias{[,dfm,missing,index,logical-method}
\title{Virtual class "dfm" for a document-feature matrix}
\usage{
\S4method{t}{dfm}(x)

\S4method{colSums}{dfm}(x, na.rm = FALSE, dims = 1, ...)

\S4method{rowSums}{dfm}(x, na.rm = FALSE, dims = 1, ...)

\S4method{colMeans}{dfm}(x, na.rm = FALSE, dims = 1, ...)

\S4method{rowMeans}{dfm}(x, na.rm = FALSE, dims = 1, ...)

\S4method{Arith}{dfm,numeric}(e1, e2)

\S4method{Arith}{numeric,dfm}(e1, e2)

\S4method{[}{dfm,index,index,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{dfm,index,index,logical}(x, i, j, ..., drop = TRUE)

\S4method{[}{dfm,missing,missing,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{dfm,missing,missing,logical}(x, i, j, ..., drop = TRUE)

\S4method{[}{dfm,index,missing,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{dfm,index,missing,logical}(x, i, j, ..., drop = TRUE)

\S4method{[}{dfm,missing,index,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{dfm,missing,index,logical}(x, i, j, ..., drop = TRUE)
}
\arguments{
\item{x}{the dfm object}

\item{na.rm}{if \code{TRUE}, omit missing values (including \code{NaN}) from
the calculations}

\item{dims}{ignored}

\item{...}{additional arguments not used here}

\item{e1}{first quantity in "+" operation for dfm}

\item{e2}{second quantity in "+" operation for dfm}

\item{i}{index for documents}

\item{j}{index for features}

\item{drop}{always set to \code{FALSE}}
}
\description{
The dfm class of object is a type of \link[Matrix]{Matrix-class} object with
additional slots, described below.  \pkg{quanteda} uses two subclasses of the
\code{dfm} class, depending on whether the object can be represented by a
sparse matrix, in which case it is a \code{dfm} class object, or if dense,
then a \code{dfmDense} object.  See Details.
}
\details{
The \code{dfm} class is a virtual class that will contain
  \link[Matrix]{dgCMatrix-class}.
}
\section{Slots}{

\describe{
\item{\code{settings}}{settings that govern corpus handling and subsequent downstream
operations, including the settings used to clean and tokenize the texts,
and to create the dfm.  See \code{\link{settings}}.}

\item{\code{weighting}}{the feature weighting applied to the dfm.  Default is
\code{"frequency"}, indicating that the values in the cells of the dfm are
simple feature counts. To change this, use the \code{\link{dfm_weight}}
method.}

\item{\code{smooth}}{a smoothing parameter, defaults to zero.  Can be changed using
the \code{\link{dfm_smooth}} method.}

\item{\code{Dimnames}}{These are inherited from \link[Matrix]{Matrix-class} but are
named \code{docs} and \code{features} respectively.}
}}

\examples{
# dfm subsetting
x <- dfm(tokens(c("this contains lots of stopwords",
                  "no if, and, or but about it: lots",
                  "and a third document is it"),
                remove_punct = TRUE))
x[1:2, ]
x[1:2, 1:5]
}
\seealso{
\link{dfm}
}
\keyword{dfm}
\keyword{internal}
