% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R, R/nsyllable.R,
%   R/textstat_readability.R
\docType{data}
\name{data-internal}
\alias{data-internal}
\alias{data_int_syllables}
\alias{data_char_wordlists}
\title{Internal data sets}
\format{An object of class \code{integer} of length 133245.}
\usage{
data_int_syllables

data_char_wordlists
}
\description{
Data sets used for mainly internal purposes by the \pkg{quanteda} package.
}
\details{
\code{data_int_syllables} provides an English-language syllables dictionary;
it is an integer vector whose element names correspond to English words.

\code{data_char_wordlists} provides word lists used in some readability indexes;
it is a named list of character vectors where each list element
corresponds to a different readability index.

These are:
\describe{
\item{\code{DaleChall}}{The long Dale-Chall list of 3,000 familiar (English)
words needed to compute the Dale-Chall Readability Formula.}
\item{\code{Spache}}{The revised Spache word list (see Klare 1975, 73) needed
to compute the Spache Revised Formula of readability (Spache 1974.}
}
}
\references{
Chall, J.S., & Dale, E. (1995). \emph{Readability Revisited: The New
Dale-Chall Readability Formula}. Brookline Books.

Dale, E. & Chall, J.S. (1948). A Formula for Predicting
Readability. \emph{Educational Research Bulletin}, 27(1): 11--20.

Dale, E. & Chall, J.S. (1948). A Formula for Predicting Readability:
Instructions. \emph{Educational Research Bulletin}, 27(2): 37--54.

Klare, G.R. (1975). Assessing Readability. \emph{Reading Research Quarterly}
10(1), 62--102.

Spache, G. (1953). A New Readability Formula for Primary-Grade Reading
Materials. \emph{The Elementary School Journal}, 53, 410--413.

Tränkle, U. & Bailer, H. (1984). Kreuzvalidierung und Neuberechnung von
Lesbarkeitsformeln für die deutsche Sprache. \emph{Zeitschrift für
Entwicklungspsychologie und Pädagogische Psychologie}, 16(3), 231--244.

Wheeler, L.R. & Smith, E.H. (1954). A Practical Readability Formula for the
Classroom Teacher in the Primary Grades. \emph{Elementary English}, 31, 
397--399.
}
\keyword{data}
\keyword{datasets}
\keyword{internal}
