% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math.R, R/ops.R, R/summary.R
\name{groupGeneric.quantities}
\alias{groupGeneric.quantities}
\alias{Math.quantities}
\alias{Ops.quantities}
\alias{Summary.quantities}
\title{S3 Group Generic Functions}
\usage{
\method{Math}{quantities}(x, ...)

\method{Ops}{quantities}(e1, e2)

\method{Summary}{quantities}(..., na.rm = FALSE)
}
\arguments{
\item{x, e1, e2}{objects.}

\item{...}{further arguments passed to methods.}

\item{na.rm}{logical: should missing values be removed?}
}
\description{
\code{Math}, \code{Ops} and \code{Summary} group generic methods for
\code{quantities} objects (see \code{\link[base]{groupGeneric}} for a
comprehensive list of available methods).
}
\details{
See \code{\link[errors]{groupGeneric.errors}},
\code{\link[units]{Ops.units}}, \code{\link[units]{Math.units}}, for further details.
}
\examples{
x <- set_quantities(1:3, m/s, 0.1)
log(x)
cumsum(x)
cumprod(x)

a <- set_quantities(1:3, m/s, 0.1)
b <- set_quantities(1:3, m/s, 0.1)
a + b
a * b
a / b
a = set_quantities(1:5, m, 0.1)
a \%/\% a
a \%/\% set_quantities(2)
set_quantities(1:5, m^2, 0.1) \%/\% set_quantities(2, m, 0.1)
a \%\% a
a \%\% set_quantities(2)
c(min(x), max(x))
range(x)
sum(x)

}
