% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Class-ClippedCov.R
\docType{class}
\name{ClippedCov-class}
\alias{ClippedCov}
\alias{ClippedCov-class}
\title{Class to calculate copula covariances from a time series with given levels.}
\description{
Calculates for each combination of levels \eqn{(\tau_1,\tau_2)}{(tau1,tau2)}
and for all \eqn{k < \code{maxLag}}{k<maxLag} the copula covariances
\eqn{Cov(1_{X_0 < \tau_1},1_{X_k < \tau_2})}{Cov(Ind{X0<tau1},Ind{Xk<tau2})}
and writes it to \code{values[k]} from its superclass \code{\link{LagOperator}}.
}
\details{
For each lag \code{k = 0, ..., maxLag} and combination of levels
\eqn{(\tau_1, \tau_2)}{(tau1, tau2)} from \code{levels.1 x levels.2} the
statistic
\deqn{\frac{1}{n} \sum_{t=1}^{n-k} ( I\{\hat F_n(Y_t) \leq \tau_1\} - \tau_1) ( I\{\hat F_n(Y_{t+k}) \leq \tau_2\} - \tau_2)}
is determined and stored to the array \code{values}.
}
\keyword{S4-classes}

