% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Class-LagKernelWeight.R
\docType{methods}
\name{getValues-LagKernelWeight}
\alias{getValues,LagKernelWeight-method}
\alias{getValues-LagKernelWeight}
\title{Get values from a weight object determined by a kernel function \code{W} and
a bandwidth \code{bw}.}
\usage{
\S4method{getValues}{LagKernelWeight}(object, K = length(object@env$values))
}
\arguments{
\item{object}{\code{LagKernelWeight} of which to get the values}

\item{K}{a \code{numeric} that determines the largest lag. The weight will be
computed for the \eqn{K} integers \eqn{0:(K-1)}; by default the number
\code{K} specified on construction.}
}
\value{
Returns a vector of size \code{K} as described in the Details section.
}
\description{
For an \code{object} of type \code{LagKernelWeight} and an optional integer
\code{K} the weights \eqn{W_k}{Wk} are returned as a vector that has
\eqn{W_k((k-1)/bw)}{Wk((k-1)/bw)} at position \code{k}.
}
\keyword{Access-functions}

