% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{recodes}
\alias{recodes}
\title{Recode Data}
\usage{
recodes(data, vrb.nm, recodes, suffix = "_r", as.factor, as.numeric = TRUE)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variables.}

\item{recodes}{character vector of length 1 specifying the recodes. See
details of \code{\link[car]{recode}} for how to use this argument.}

\item{suffix}{character vector of length 1 specifying the string to add to
the end of the colnames in the return object.}

\item{as.factor}{logical vector of length 1 specifying if the recoded columns
should be returned as factors. The default depends on the column in
\code{data[vrb.nm]}. If the column is a factor, then \code{as.factor} =
TRUE for that column. If the column is not a factor, then \code{as.factor}
= FALSE for that column. Any non-default, specified value for this argument
will result in \code{as.factor} being universally applied to all columns in
\code{data[vrb.nm]}.}

\item{as.numeric}{logical vector of length 1 specifying if the recoded
columns should be returned as numeric vectors when possible. This can be
useful when having character vectors converted to numeric, such that
numbers with typeof character (e.g., "1") will be coerced to typeof numeric
(e.g., 1). Note, this argument has no effect on columns in
\code{data[vrb.nm]} which are typeof character and have letters in their
values (e.g., "1a"). Note, this argument is often not needed as you can
directly recode to a numeric by excluding quotes from the number in the
\code{recodes} argument.}
}
\value{
data.frame of recoded variables with colnames specified by
  \code{paste0(vrb.nm, suffix)}. In general, the columns of the data.frame
  are the same typeof as those in \code{data} except for instances when
  \code{as.factor} and/or \code{as.numeric} change the typeof.
}
\description{
\code{recodes} recodes data based on specified recodes using the
\code{car::recode} function. This can be used for numeric or character
(including factors) data. See \code{\link[car]{recode}} for details. The
\code{levels} argument from \code{car::recode} is excluded because there is
no easy way to vectorize it when only a subset of the variables are factors.
}
\examples{
recodes(data = psych::bfi, vrb.nm = c("A1","C4","C5","E1","E2","O2","O5"),
   recodes = "1=6; 2=5; 3=4; 4=3; 5=2; 6=1")
re_codes <- "'Quebec' = 'canada'; 'Mississippi' = 'usa'; 'nonchilled' = 'no'; 'chilled' = 'yes'"
recodes(data = CO2, vrb.nm = c("Type","Treatment"), recodes = re_codes,
   as.factor = FALSE) # convert from factors to characters
}
\seealso{
\code{\link[car]{recode}}
   \code{\link{reverses}}
}
