% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/tables.r
\name{freq.na}
\alias{freq.na}
\title{Generate frequency table of missing values.}
\usage{
freq.na(data, ...)
}
\arguments{
\item{data}{either a vector or a data frame object}

\item{...}{if \code{x} is a data frame, the names of the variables to examine. When no variable names are provided, the function examines the full data frame and returns the five variables with most missing values.}
}
\value{
The result is an object of class data.frame.
}
\description{
Generate a frequency table of missing values as raw counts and percentages.
}
\examples{
data(hdv2003)
## Examine a single vector.
freq.na(hdv2003$qualif)
## Examine a data frame.
freq.na(hdv2003)
## Examine several variables.
freq.na(hdv2003, "nivetud", "trav.satisf")
## Examine all variables.
freq.na(hdv2003, names(hdv2003))
}
\seealso{
\code{\link{table}}, \code{\link{is.na}}
}

