% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-helpers.R
\docType{methods}
\name{equalExtent}
\alias{equalExtent}
\alias{equalExtent,list-method}
\title{Assess whether a list of extents are all equal}
\usage{
equalExtent(extents)

\S4method{equalExtent}{list}(extents)
}
\arguments{
\item{extents}{list of extents objects}
}
\description{
Assess whether a list of extents are all equal
}
\examples{
library(igraph)
library(raster)

files <- system.file("maps", package = "quickPlot") \%>\%
  dir(., full.names = TRUE, pattern = "tif")
maps <- lapply(files, function(x) raster(x))
names(maps) <- sapply(basename(files), function(x) {
  strsplit(x, split = "\\\\.")[[1]][1]
})
extnts <- lapply(maps, extent)
equalExtent(extnts) ## TRUE

}
\author{
Eliot McIntire
}
