% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quint.control.R
\name{quint.control}
\alias{quint.control}
\title{Control Parameters for QUINT Algorithm}
\usage{
quint.control(crit = "es", maxl = 10, a1 = NULL, a2 = NULL, w = NULL,
  Bootstrap = TRUE, B = 25, dmin = 0.3)
}
\arguments{
\item{crit}{the type of difference in treatment outcome used in the
partitioning criterion: "es" (Treatment effect sizes) or
"dm" (Difference in treatment means).}

\item{maxl}{maximum number of leaves (\eqn{L}) of the tree. Default value is 10.}

\item{a1}{the minimal sample size of Treatment A (\eqn{T=1}) in a leaf.}

\item{a2}{the minimal sample size of Treatment B (\eqn{T=2}) in a leaf.}

\item{w}{a vector with w1 and w2 representing the weights of, respectively,
the Difference in treatment outcome component and the Cardinality component
of the partitioning criterion. If crit = "dm", the default value of \eqn{w1}
is \eqn{1/ log(1+IQR(Y))}. If crit = "es", the default value of \eqn{w1} is
\eqn{1/log(1+3)}. The default of \eqn{w2} is \eqn{1/log(0.50N)}.}

\item{Bootstrap}{whether the bias-corrected bootstrap procedure should
be performed. The default is TRUE.}

\item{B}{the number of bootstrap samples to be drawn. The default is 25. We recommend a number of bootstraps of at least 25.}

\item{dmin}{the minimum absolute standardized mean difference in
treatment outcome in each of the two leaves after the first split
of the tree. This value is used to check whether a qualitative interaction
is present in the data (the qualitative interaction condition); dmin controls
the balance between Type I error and Type II error. The default value of dmin is 0.30.}
}
\value{
A list containing the options.
}
\description{
Various parameters that control aspects of the \dQuote{quint} algorithm.
Appendix A of Dusseldorp & Van Mechelen (2013) gives a detailed overview
of the choices that can be made.
}
\examples{
data(bcrp)
formula1<- I(cesdt1-cesdt3)~cond | nationality+marital+wcht1+age+
  trext+comorbid+disopt1+uncomt1+negsoct1
#Specify the Difference in treatment outcome as Difference in means
#and skip the bias-corrected bootstrap procedure
#and change the maximum number of leaves
control3<-quint.control(crit="dm",Bootstrap=FALSE,maxl=3)
quint3<-quint(formula1, data= subset(bcrp,cond<3),control=control3)
summary(quint3)

#Set number of bootstrap samples at 30
control4<-quint.control(B=30)

#Set minimal sample size in each treatment group at 5
control5<-quint.control(a1=5,a2=5)

}
\references{
Dusseldorp E., Doove L. and Van Mechelen I. (2015). Quint: An
  R package for the identification of subgroups of clients who differ in which treatment
  alternative is best for them. \emph{Behavior research methods (ahead-of-print)}, 1-14.
  DOI: 10.3758/s13428-015-0594-z.

  Dusseldorp E. and Van Mechelen I. (2014). Qualitative interaction
  trees: a tool to identify qualitative treatment-subgroup interactions.
  \emph{Statistics in Medicine, 33(2)}, 219-237. DOI: 10.1002/sim.5933.
}
\seealso{
\code{\link{quint}}
}
