% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALDqr_GCD.R
\name{ALDqr_GCD}
\alias{ALDqr_GCD}
\title{Generalized Cook's distance for each observation in quantile
regression model}
\usage{
ALDqr_GCD(y, x, tau, error, iter)
}
\arguments{
\item{y}{Dependent variable in quantile regression. Note that:
we suppose y follows asymmetric laplace distribution.}

\item{x}{indepdent variables in quantile regression.
Note that: x is the independent variable matrix which including
the intercept. That means, if the dimension of independent
variables is p and the sample size is n, x is a n times p+1
matrix with the first column being one.}

\item{tau}{quantile}

\item{error}{the EM algorithm accuracy of error used in
MLE estimation}

\item{iter}{the iteration frequancy for EM algorithm used
in MLE estimation}
}
\description{
Generalized Cook's distance for each observation in quantile
regression model
}
\details{
Gerneralized Cook's distance is a commonly used estimate
of the influence of a data point when performing regression
analysis. It involves the log-likelihood function based on the
complete data and case-deletion data.
To assess the influence of the \eqn{i}th case with estimate
\eqn{\hat{\theta}},
we compare \eqn{\hat{\theta_(i)}} and \eqn{\hat{\theta}}, and if
\eqn{\hat{\theta_(i)}}
is far from \eqn{\hat{\theta_(i)}}, then the \eqn{i}th case is
regarded as influential. We consider here the following
generalized Cook's distance:
\deqn{GCD_{i} = (\hat{\theta_{(i)}}-\hat{\theta{i}})^{'}
{-Q(\hat{\theta}|\hat{\theta})}
(\hat{\theta_{(i)}}-\hat{\theta{i}})}
\deqn{Q_{(i)}(\theta|\hat{\theta})=E_{\hat{\theta}}[l_{c}(\theta|Y_{c(i)})|y]}
More details please refer to the paper in references
}
\references{
Benites L E, Lachos V H, Vilca F E.(2015)``Case-Deletion
Diagnostics for Quantile Regression Using the Asymmetric Laplace
Distribution,\emph{arXiv preprint arXiv:1509.05099}.
}
\seealso{
\code{ALDqr_QD}
}
