% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame_fn_path.R
\name{frame_fn_path}
\alias{frame_fn_path}
\title{Visualization of the fitting path
of quantile regression: interior point method}
\usage{
frame_fn_path(object, tau)
}
\arguments{
\item{object}{quantile regression model using interior point method}

\item{tau}{quantile}
}
\value{
The fitting path of quantile regression model using interior
point method
}
\description{
observations used in quantile regression fitting

\deqn{min_{b \in R^{p}}\sum_{i=1}^{n}\rho_{\tau}(y_i-x_{i}^{'}b)}

where \eqn{\rho_{\tau}(r)=r[\tau-I(r<0)]$ for $\tau \in (0,1)}. This
yields the modified linear program

\deqn{min(\tau e^{'}u+(1-\tau)e^{'}v|y=Xb+u-v,(u,v) \in
R_{+}^{2n})}

Adding slack variables, \eqn{s}, satisfying the constrains
\eqn{a+s=e}, we
obtain the barrier function

\deqn{B(a, s, u) = y^{'}a+\mu \sum_{i=1}^{n}(loga_{i}+logs_{i})}

which should be maximized subject to the constrains
\eqn{X^{'}a=(1-\tau)X^{'}e} and \eqn{a+s=e}. The Newton step
\eqn{\delta_{a}}
solving

\deqn{max{y^{'}\delta_{a}+\mu \delta^{'}_{a}(A^{-1}-S^{-1})e-
\frac{1}{2}\mu \delta_{a}^{'}(A^{-2}+S^{-2})\delta_{a}}}

subject to \eqn{X{'}\delta_{a}=0}, satisfies

\deqn{y+\mu(A^{-1}-S^{-1})e-\mu(A^{-2}+S^{-2})\delta_{a}=Xb}

for some \eqn{b\in R^{p}}, and \eqn{\delta_{a}} such that
\eqn{X^{'}\delta_{a}=0}.
Using the constraint, we can solve explicitly for the vector
\eqn{b},

\deqn{b=(X^{'}WX)^{-1}X^{'}W[y+\mu(A^{-1}-S^{-1})e]}

where \eqn{W=(A^{-2}+S^{-2})^{-1}}. This is a form of the primal log
barrier algorithm described above. Setting \eqn{\mu=0} in each step
yields an affine scaling variant of the algorithm. The basic linear
algebra of each iteration is essentially unchanged, only the form
of the diagonal weighting matrix \eqn{W} has chagned.
}
\details{
This function used to illustrate the fitting process of
quantile regression using interior point method.
Koenker and Bassett(1978) introduced asymmetric weight on positive
and negative residuals, and solves the slightly modified l1-problem.
}
\examples{
\dontrun{
library(ggplot2)
library(quantreg)
data(ais)
tau <- c(0.1, 0.5, 0.9)
object <-rq(BMI ~ LBM + Ht, tau = tau, data = ais, method = 'fn')
frame_fn <- frame_fn_path(object, tau)
#plot the path
frame_fn1 <- frame_fn[[1]]
ggplot(frame_fn1, aes(x = value, y = objective)) +
   geom_point() +
   geom_path() +
   facet_wrap(~ variable, scale = 'free')
}
}
\references{
Portnoy S, Koenker R. The Gaussian hare and the Laplacian tortoise:
computability of squared-error versus absolute-error estimators.
\emph{Statistical Science}, 1997, 12(4): 279-300.
}
\author{
Wenjing Wang \email{wenjingwangr@gmail.com}
}
