% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification_bridge.R
\docType{data}
\name{classification_bridge}
\alias{classification_bridge}
\alias{isic_classification}
\alias{nace_classification}
\alias{naics_classification}
\title{Datasets to bridge (translate) common sector-classification codes}
\format{
\code{classification_bridge} is a \link{data.frame} with columns:
\itemize{
\item \code{borderline} (logical): Flag indicating if 2dii sector and classification
code are a borderline match.
\item \code{code} (character): Original ISIC code.
\item \code{code_level} (double): Level of granularity of ISIC code.
\item \code{sector} (character): Associated 2dii sector.
}

\code{nace_classification} is a \link{data.frame} with columns:
\itemize{
\item \code{borderline} (logical): Flag indicating if 2dii sector and classification
code are a borderline match.
\item \code{code} (double): Formatted NACE code removing periods.
\item \code{code_level} (double): Level of granularity of NACE code.
\item \code{original_code} (double): Original NACE code.
\item \code{sector} (character): Associated 2dii sector.
}

\code{naics_classification} is a \link{data.frame} with columns:
\itemize{
\item \code{borderline} (logical): Flag indicating if 2dii sector and classification
code are a borderline match.
\item \code{code} (double): Formatted NAICS code.
\item \code{code_level} (double): Level of granularity of NAICS code.
\item \code{original_code} (double): Original NAICS code.
\item \code{sector} (character): Associated 2dii sector.
}
}
\usage{
isic_classification

nace_classification

naics_classification
}
\description{
These datasets serve as a translation key between common sector-classification
systems and sectors relevant to the 'PACTA' tool
(\url{https://2degrees-investing.org/resource/pacta/}).

Classification datasets help to standardize sector classification codes from
the wild to a relevant subset including 'power', 'oil and gas', 'coal',
'automotive', 'aviation', 'concrete', 'steel', and 'shipping'.
}
\examples{
head(isic_classification)

head(nace_classification)

head(naics_classification)
}
\seealso{
\link{data_dictionary}.

Other datasets for bridging sector classification codes: 
\code{\link{sector_classifications}}
}
\concept{datasets for bridging sector classification codes}
\keyword{datasets}
