\name{r2lb}
\alias{r2lb}
\alias{r2latexBiv}


\title{~ Function: R to LaTeX, Bivariate analysis ~}

\description{
  \code{r2latexBiv} (\code{r2lb} in short) performs some bivariate analyses, then generates code to be
  included in a LaTeX document in order to print out the analyses in a (so nice!) LaTeX way.
}


\usage{
  r2lb(formula,fileOut="",textBefore="",textAfter="",graphDir="graphBiv",graphName="V",type="png",displayStyle=7,limDiscreteY=10,limDiscreteX=10)
  r2latexBiv(formula,fileOut="",textBefore="",textAfter="",graphDir="graphBiv",graphName="V",type="png",displayStyle=7,limDiscreteY=10,limDiscreteX=10)
}

\arguments{
  \item{formula}{\code{[variable~variable]} or \code{[variable~data.frame]} : contains the
    data to analyse. In all the following, the left part will be called
    \code{Y}, the right part will be \code{X}.}

  \item{fileOut}{\code{[character]}
    name of the output file in which
    the LaTeX summary will be saved. If empty, the LaTeX code is printed on screen.}

  \item{textBefore}{\code{[character] or [vector(character)]} : before
    printing a variable analysis, \code{r2lb} can write a
    text. If \code{X} is a single variable,
    \code{textBefore} should be of length 1. If \code{X} is a \code{data.frame},
    \code{textBefore} can have same length as the number of columns of the \code{data.frame} (this lets
    the user write a specific introduction for each variable), or can be
    of length 1. In this case, it is recycled. See examples for details.}

  \item{textAfter}{\code{[character]} or \code{[vector(character)]} : same
    as \code{textBefore} but the text is printed after the variable
    analysis. See \code{textBefore} and examples for details.}

  \item{graphDir}{\code{[character]} :
    directory used to save the graphs generated by the analyses.}

  \item{graphName}{\code{[character]} or \code{[vector(character)]} :
    prefix for the graph names. If empty, the graph names are
    \code{V1} to \code{V'length(data.frame)'}}

  \item{type}{\code{[character]} : type of plotting device used to export the
    graphics. Can be Windows metafile, PNG, JPEG, BMP (Windows bitmap format), TIFF,
    PostScript or PDF.}

  \item{displayStyle}{\code{[numeric]} or \code{[vector(numeric)]} :
    \code{r2lb} proposes two different ways of displaying the results.

    The first one is compact, it displays all the results on two lines. If the
    number of modalities of \code{X} is too big, this
    method could draw tables that outfit the page. In this case, a second display (on
    three lines, less compact but higher) is used.

    The switch (compact/expanded) is done automatically by \code{r2lb}
    according to the number of modalities of \code{X}: when it is lower
    than \code{displayStyle}, the compact style is used. When it is greater
    or egal, the expanded style is used.

    If \code{X} is a data.frame, \code{displayStyle} can have the same
    length as \code{X}, or can be of length 1 (and be recycled).}

  \item{limDiscreteY}{\code{[numeric]} : \code{r2lb} distinguishes two
    kinds of \code{numeric} variables:
    \code{discrete} designates \code{numeric} with only a few
    modalities,  \code{continuous} designates \code{numeric} with many
    modalities. For the variable \code{Y}, the limit between 'few' and 'many' can be fixed by the
    user through the \code{limDiscreteY} argument. By setting
    \code{limDiscreteY} to 5, the user will ask \code{r2lb} to consider
    all the \code{numeric} variables with more than 5 modalities as
    \code{continuous} and all the variables with 5 modalities or less
    as \code{discrete}.

    The default value for \code{limDiscreteY} is 10.}

  \item{limDiscreteX}{\code{[numeric]} or \code{[vector(numeric)]}: same
    as \code{limDiscreteY}. If \code{X} is a \code{data.frame}, \code{limDiscreteX} can have the same
    length as \code{X} or can be of length 1 (and is recycled).}
}

\details{
  \code{r2lb} performs some basic analyses, then generates
  code to be included in a LaTeX document in order to print out the analyses in a (so
  nice!) LaTeX way.

  \code{r2lb} performs the analyses automatically according to the
  \code{data} class. It considers 5 classes: nominal with 2 modalities,
  nominal with 3 modalities or more, ordered, discrete and
  continuous (see the description of \code{limDiscreteY} for details on
  discrete and continuous).

  The analysis of the variable depends on the class of \code{Y} and
  \code{X} wich gives 25 possible combinations. We will not give a
  description here, all of them are presented in the pdf file \url{/library/r2lh/doc/r2lhOutput.pdf}.

  They can be divided in two categories. First (on the top of the
  tabular) are descriptive analyses:
  \enumerate{
    \item table: absolute and relative frequency.
    \item summary: mainly when\code{Y} is continuous and \code{X} has
    few modalities.
    \item graphical representation: barplot or boxplot for each
    modalities of \code{X}, mosaic plot, scatter plot, density lines
    according to the type of the variable.
  }

  On the second part of the tabular are all the informations related to
  a potential link between \code{Y} and \code{X}.
  \enumerate{
    \item test: khi2, Fisher exact test, Student's T, ANOVA, Wilcoxon, Kruskal & Wallis,
    Spearman correlation, Pearson correlation, Odds Ratio and Relative
    Risk, depending on the classes of \code{Y} and \code{X}. Note that as
    many tests as possible are run. For example, if \code{Y} is nominal
    and \code{X}is ordered, \code{X} can be considered as
    a factor (khi2 and Fisher exact test) but also as a discrete variable (Wilcoxon).
    \item graphical diagnostic: the test presented might not be all valid. Some
    graphical diagnostic (check for normality) are presented to let the user
    decide which test is more relevant.
  }

  The wide display gives :
  \preformatted{
+---+---+---+
| 1 | 2 | 3 |
+---+-+-+---+
|  4  |  5  |
+-----+-----+
  }

  The long display :
  \preformatted{
+-------+
|   1   |
+---+---+
| 2 | 3 |
+---+---+
| 4 | 5 |
+---+---+
  }

  If \code{X} is a \code{data.frame}, \code{r2lb} runs the analyses on
  every column.

  See \url{/library/r2lh/doc/r2lhOutput.pdf} for display details.
}

\value{
  \code{r2lb} generates LaTeX code and either prints it on the screen, or saves it in a
  file. It also generates several graphs, optionally
  in a different directory.
}

\section{Classical usage}{
  The use of \code{r2lb} goes through the following steps:
  \tabular{ll}{
    Step 1. \tab Load the data (usually, a \code{data.frame}).\cr
    Step 2. \tab Optionally, set some variables as \code{ordered}. \cr
    Step 3. \tab Run \code{r2lb(Y~dataFrame,"fileOut.tex")}.\cr
  }
  See examples of application.
}


\section{Author}{
  Christophe Genolini \cr
  \email{christophe.genolini@free.fr}\cr
  PSIGIAM: Paris Sud Innovation Group in Adolescent Mental Health \cr
  INSERM U669 / Maison de Solenn / Paris\cr
  \cr
  Bernard Desgraupes \cr
  \email{bernard.desgraupes@u-paris10.fr}\cr
  University of Paris Ouest - Nanterre
}


\references{LaTeX web site \url{http://www.latex-project.org/}\cr
  Data are available on line:
  \url{http://christophe.genolini.free.fr/EPO/EPO2007-Fraude.php}
}



\seealso{
  \code{\link{r2lMainFile}},
  \code{\link{r2lu}},
  \code{\link{r2latexUniv-package}},
  \code{\link{examCheating}},
  \code{\link{Sweave}},
  \code{\link[Hmisc]{latex}}
}

\examples{
 # # # # # # # # # # # # # # # # # # #
#    R to LaTeX, Bivariate Analyses   #
 #        Artificial examples        #
  #         Single variable         #
   # # # # # # # # # # # # # # # # #

### Create some data
V1 <- factor(LETTERS[floor(runif(50,1,4))])
V2 <- rnorm(50,1,1)<0
V3 <- ordered(LETTERS[floor(runif(50,1,4))])

### Create a directory for the output
if(!file.exists("tmp/r2lbExample",recursive=TRUE)){dir.create("tmp/r2lbExample",recursive=TRUE)}else{}
setwd("tmp/r2lbExample")

### Execute r2lb
r2lb(V1~V2,fileOut="first.tex",textBefore="\\\\section{Variables V1, V2, V3}",graphName="Gr1",type="postscript")
r2lb(V2~V1,fileOut="second.tex",graphName="Gr2",type="postscript")
r2lb(V3~V1,fileOut="third.tex",textBefore="This is V3 vs. V1",graphDir="P",graphName="Gr3",type="postscript",displayStyle=2)
r2lMainFile(text="\\\\input{first.tex}\n\\\\input{second.tex}\n\\\\input{third.tex}")
setwd("../..")

}

\keyword{print}        % Printing
\keyword{classes}      % Data type
\keyword{programming}  % Programming
\keyword{interface}    % interface to other languages
\keyword{utilities}    % Utilities
\keyword{univar}       % Simple univariate statistics




