% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2mlm_manual.R
\name{r2mlm_manual}
\alias{r2mlm_manual}
\title{Compute R-squared values for multilevel models, manually inputting parameter
estimates.}
\usage{
r2mlm_manual(
  data,
  within_covs,
  between_covs,
  random_covs,
  gamma_w,
  gamma_b,
  Tau,
  sigma2,
  has_intercept = TRUE,
  clustermeancentered = TRUE
)
}
\arguments{
\item{data}{Dataset with rows denoting observations and columns denoting
variables.}

\item{within_covs}{List of numbers corresponding to the columns in the
dataset of the level-1 predictors used in the MLM (if none used, set to
NULL).}

\item{between_covs}{List of numbers corresponding to the columns in the
dataset of the level-2 predictors used in the MLM (if none used, set to
NULL).}

\item{random_covs}{List of numbers corresponding to the columns in the
dataset of the level-1 predictors that have random slopes in the MLM (if no
random slopes, set to NULL).}

\item{gamma_w}{Vector of fixed slope estimates for all level-1 predictors, to
be entered in the order of the predictors listed by within_covs (if none,
set to NULL).}

\item{gamma_b}{Vector of fixed intercept estimate (if applicable; see
has_intercept below) and fixed slope estimates for all level-2 predictors,
to be entered intercept first (if applicable) followed by level-2 slopes in
the order listed by between_covs (if none, set to NULL).}

\item{Tau}{Random effect covariance matrix; note that the first row/column
denotes the intercept variance and covariances (if intercept is fixed, set
all to 0) and each subsequent row/column denotes a given random slope’s
variance and covariances (to be entered in the order listed by
random_covs).}

\item{sigma2}{Level-1 residual variance.}

\item{has_intercept}{If set to TRUE, the first element of gamma_b is assumed
to be the fixed intercept estimate; if set to FALSE, the first element of
gamma_b is assumed to be the first fixed level- 2 predictor slope; set to
TRUE by default.}

\item{clustermeancentered}{If set to TRUE, all level-1 predictors (indicated
by the within_covs list) are assumed to be cluster-mean-centered and
function will output all decompositions; if set to FALSE, function will
output only total decompositions (see Description above); set to TRUE by
default.}
}
\value{
If the input is valid, then the output will be a list and associated
  graphical representation of R-squared decompositions. If the input is not
  valid, it will return an error.
}
\description{
\code{r2mlm_manual} takes as input raw data and parameter estimates from a
multilevel model, and outputs all relevant R-squared measures from the Rights
and Sterba (2019) framework of R-squared measures for multilevel models,
which can be visualized together as a set using the outputted bar chart
decompositions of outcome variance. That is, when predictors are
cluster-mean-centered, all R-squared measures from Rights & Sterba (2019)
Table 1 and decompositions from Rights & Sterba (2019) Figure 1 are
outputted. When predictors are not cluster-mean-centered, the total
R-squareds from Rights & Sterba (2019) Table 5, as well as bar chart
decompositions are outputted. Any number of level-1 and/or level-2 predictors
is supported. Any of the level-1 predictors can have random slopes.
}
\examples{

# The bobyqa optimizer is required for this model to converge in lme4

model <- lmer(satisfaction ~ 1 + salary_c + control_c + salary_m + control_m
+ s_t_ratio + (1 + salary_c + control_c | schoolID), data = teachsat, REML =
TRUE, control = lmerControl(optimizer = "bobyqa"))

r2mlm_manual(data = teachsat, within_covs = c(5, 4), between_covs = c(7, 6,
8), random_covs =  c(5, 4), gamma_w = c(1.55160, 2.69277), gamma_b =
c(19.68596,1.45138 , 3.68630, -0.37230), Tau = matrix(c(18.548, -0.676,
-0.396, -0.676, 1.064, -0.143, -0.396, -0.143, 3.612), 3, 3), sigma2 =
39.821, has_intercept = TRUE, clustermeancentered = TRUE)

}
\seealso{
\href{https://doi.org/10.1037/met0000184}{Rights, J. D., & Sterba,
  S. K. (2019). Quantifying explained variance in multilevel models: An
  integrative framework for defining R-squared measures. Psychological
  Methods, 24(3), 309–338.}

Other r2mlm single model functions: 
\code{\link{r2mlm}()}
}
\concept{r2mlm single model functions}
