/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.PMML;
import org.dmg.pmml.UnivariateStats;
import org.dmg.pmml.Visitable;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.visitors.CleanerBattery;

public class ModelEncoder
extends PMMLEncoder {
    private Map<FieldName, List<Decorator>> decorators = new LinkedHashMap<FieldName, List<Decorator>>();
    private Map<FieldName, UnivariateStats> univariateStats = new LinkedHashMap<FieldName, UnivariateStats>();

    public PMML encodePMML(Model model) {
        PMML pmml = this.encodePMML();
        pmml.addModels(new Model[]{model});
        CleanerBattery visitorBattery = new CleanerBattery();
        if (visitorBattery.size() > 0) {
            visitorBattery.applyTo((Visitable)pmml);
        }
        MiningSchema miningSchema = model.getMiningSchema();
        List miningFields = miningSchema.getMiningFields();
        for (MiningField miningField : miningFields) {
            FieldName name = miningField.getName();
            List<Decorator> decorators = this.getDecorators(name);
            if (decorators == null) continue;
            DataField dataField = this.getDataField(name);
            if (dataField == null) {
                throw new IllegalArgumentException();
            }
            for (Decorator decorator : decorators) {
                decorator.decorate(dataField, miningField);
            }
        }
        DataDictionary dataDictionary = pmml.getDataDictionary();
        List dataFields = dataDictionary.getDataFields();
        for (DataField dataField : dataFields) {
            UnivariateStats univariateStats = this.getUnivariateStats(dataField.getName());
            if (univariateStats == null) continue;
            ModelStats modelStats = model.getModelStats();
            if (modelStats == null) {
                modelStats = new ModelStats();
                model.setModelStats(modelStats);
            }
            modelStats.addUnivariateStats(new UnivariateStats[]{univariateStats});
        }
        return pmml;
    }

    public List<Decorator> getDecorators(FieldName name) {
        return this.decorators.get(name);
    }

    public void addDecorator(FieldName name, Decorator decorator) {
        List<Decorator> decorators = this.decorators.get(name);
        if (decorators == null) {
            decorators = new ArrayList<Decorator>();
            this.decorators.put(name, decorators);
        }
        decorators.add(decorator);
    }

    public UnivariateStats getUnivariateStats(FieldName name) {
        return this.univariateStats.get(name);
    }

    public void putUnivariateStats(UnivariateStats univariateStats) {
        this.putUnivariateStats(univariateStats.getField(), univariateStats);
    }

    public void putUnivariateStats(FieldName name, UnivariateStats univariateStats) {
        this.univariateStats.put(name, univariateStats);
    }
}

