/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.collect.Lists;
import com.google.common.math.DoubleMath;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.adapters.ObjectUtil;

public class ValueUtil {
    private static final Double ZERO = 0.0;
    private static final Double ONE = 1.0;

    private ValueUtil() {
    }

    public static String asString(Object value) {
        value = ObjectUtil.toSimpleValue((Object)value);
        return value.toString();
    }

    public static boolean isNaN(Object value) {
        return Objects.equals(Float.valueOf(Float.NaN), value) || Objects.equals(Double.NaN, value);
    }

    public static boolean isZero(Number number) {
        return ValueUtil.equals(number, ZERO);
    }

    public static boolean isOne(Number number) {
        return ValueUtil.equals(number, ONE);
    }

    public static boolean isZeroLike(Number number) {
        return ValueUtil.isZero(number) || ValueUtil.isNaN(number);
    }

    public static Number asNumber(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        throw new IllegalArgumentException("Expected number, got " + object);
    }

    public static List<Number> asNumbers(List<?> objects) {
        if (objects == null) {
            return null;
        }
        return Lists.transform(objects, object -> ValueUtil.asNumber(object));
    }

    public static int asInt(Number number) {
        if (number instanceof Integer) {
            return (Integer)number;
        }
        double value = number.doubleValue();
        if (DoubleMath.isMathematicalInteger((double)value)) {
            return Ints.checkedCast((long)((long)value));
        }
        throw new IllegalArgumentException("Expected integer, got " + number);
    }

    public static Integer asInteger(Number number) {
        return ValueUtil.asInt(number);
    }

    public static List<Integer> asIntegers(List<? extends Number> numbers) {
        if (numbers == null) {
            return null;
        }
        return Lists.transform(numbers, number -> ValueUtil.asInteger(number));
    }

    public static Double asDouble(Number number) {
        if (number instanceof Double) {
            return (Double)number;
        }
        return number.doubleValue();
    }

    public static List<Double> asDoubles(List<? extends Number> numbers) {
        if (numbers == null) {
            return null;
        }
        return Lists.transform(numbers, number -> ValueUtil.asDouble(number));
    }

    public static Number narrow(double value) {
        if (DoubleMath.isMathematicalInteger((double)value)) {
            return ValueUtil.narrow((long)value);
        }
        return value;
    }

    public static Number narrow(long value) {
        if (value >= -128L && value <= 127L) {
            return (byte)value;
        }
        if (value >= -32768L && value <= 32767L) {
            return (short)value;
        }
        if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
            return (int)value;
        }
        return value;
    }

    public static BitSet getIndices(List<? extends Number> values, Number targetValue) {
        BitSet result = new BitSet(values.size());
        for (int i = 0; i < values.size(); ++i) {
            Number value = values.get(i);
            if (!ValueUtil.equals(value, targetValue)) continue;
            result.set(i, true);
        }
        return result;
    }

    public static boolean isSparse(List<? extends Number> values, Number defaultValue, double threshold) {
        if (threshold < 0.0 || threshold > 1.0) {
            throw new IllegalArgumentException();
        }
        int count = 0;
        for (Number number : values) {
            if (!ValueUtil.equals(number, defaultValue)) continue;
            ++count;
        }
        return (double)count / (double)values.size() >= threshold;
    }

    public static <E> List<E> filterByIndices(List<E> list, BitSet filter) {
        ArrayList<E> result = new ArrayList<E>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            E element = list.get(i);
            if (!filter.get(i)) continue;
            result.add(element);
        }
        return result;
    }

    public static boolean equals(Number value, Number targetValue) {
        if (Objects.equals(value, targetValue)) {
            return true;
        }
        return value.doubleValue() == targetValue.doubleValue();
    }

    public static Number add(MathContext mathContext, Number first, Number second) {
        if (mathContext == null) {
            mathContext = MathContext.DOUBLE;
        }
        switch (mathContext) {
            case FLOAT: {
                return Float.valueOf(first.floatValue() + second.floatValue());
            }
            case DOUBLE: {
                return first.doubleValue() + second.doubleValue();
            }
        }
        throw new IllegalArgumentException();
    }

    public static Number subtract(MathContext mathContext, Number first, Number second) {
        if (mathContext == null) {
            mathContext = MathContext.DOUBLE;
        }
        switch (mathContext) {
            case FLOAT: {
                return Float.valueOf(first.floatValue() - second.floatValue());
            }
            case DOUBLE: {
                return first.doubleValue() - second.doubleValue();
            }
        }
        throw new IllegalArgumentException();
    }

    public static Number multiply(MathContext mathContext, Number first, Number second) {
        if (mathContext == null) {
            mathContext = MathContext.DOUBLE;
        }
        switch (mathContext) {
            case FLOAT: {
                return Float.valueOf(first.floatValue() * second.floatValue());
            }
            case DOUBLE: {
                return first.doubleValue() * second.doubleValue();
            }
        }
        throw new IllegalArgumentException();
    }

    public static Number divide(MathContext mathContext, Number first, Number second) {
        if (mathContext == null) {
            mathContext = MathContext.DOUBLE;
        }
        switch (mathContext) {
            case FLOAT: {
                return Float.valueOf(first.floatValue() / second.floatValue());
            }
            case DOUBLE: {
                return first.doubleValue() / second.doubleValue();
            }
        }
        throw new IllegalArgumentException();
    }

    public static Number sum(MathContext mathContext, Collection<Number> values) {
        Iterator<Number> it = values.iterator();
        Number result = it.next();
        while (it.hasNext()) {
            result = ValueUtil.add(mathContext, result, it.next());
        }
        return result;
    }

    public static Number product(MathContext mathContext, Collection<Number> values) {
        Iterator<Number> it = values.iterator();
        Number result = it.next();
        while (it.hasNext()) {
            result = ValueUtil.multiply(mathContext, result, it.next());
        }
        return result;
    }
}

