/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import org.dmg.pmml.MiningField;
import org.dmg.pmml.MissingValueTreatmentMethod;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.ValueUtil;

public class MissingValueDecorator
implements Decorator {
    private MissingValueTreatmentMethod missingValueTreatment = null;
    private Object missingValueReplacement = null;

    public MissingValueDecorator(MissingValueTreatmentMethod missingValueTreatment, Object missingValueReplacement) {
        if (missingValueTreatment == MissingValueTreatmentMethod.RETURN_INVALID) {
            if (missingValueReplacement != null) {
                throw new IllegalArgumentException();
            }
        } else if (missingValueReplacement != null && ValueUtil.isNaN(missingValueReplacement)) {
            throw new IllegalArgumentException("Expected a valid value as a missing value replacement value, got an invalid value (NaN)");
        }
        this.setMissingValueTreatment(missingValueTreatment);
        this.setMissingValueReplacement(missingValueReplacement);
    }

    @Override
    public void decorate(MiningField miningField) {
        miningField.setMissingValueTreatment(this.getMissingValueTreatment()).setMissingValueReplacement(this.getMissingValueReplacement());
    }

    public MissingValueTreatmentMethod getMissingValueTreatment() {
        return this.missingValueTreatment;
    }

    private void setMissingValueTreatment(MissingValueTreatmentMethod missingValueTreatment) {
        this.missingValueTreatment = missingValueTreatment;
    }

    public Object getMissingValueReplacement() {
        return this.missingValueReplacement;
    }

    private void setMissingValueReplacement(Object missingValueReplacement) {
        this.missingValueReplacement = missingValueReplacement;
    }
}

