% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/containerResizer.R
\name{splitCard}
\alias{splitCard}
\title{Resizable split screen container}
\usage{
splitCard(
  left,
  right,
  splitter.color = NULL,
  bg.left.color = NULL,
  left.bg.url = NULL,
  right.bg.url = NULL,
  bg.right.color = NULL,
  border.color = NULL,
  position = c("vertical", "horizontal"),
  text.left.color = "black",
  text.right.color = "black"
)
}
\arguments{
\item{left}{content on the left or top}

\item{right}{content on the right or bottom}

\item{splitter.color}{splitter color e.g red, black or #333333}

\item{bg.left.color}{left panel color e.g red, black or #333333}

\item{left.bg.url}{left panel background image e.g image1.png or https://..image1.png}

\item{right.bg.url}{right panel background image e.g image1.png or https://..image1.png}

\item{bg.right.color}{right panel color e.g red, black or #333333}

\item{border.color}{border color of the container e.g. red or #f5f5f5}

\item{position}{position of divider or splitter}

\item{text.left.color}{color of left panel text}

\item{text.right.color}{color of right panel text}
}
\value{
Resizeable split screen container
}
\description{
Highly customizable and resizable split screen container
}
\section{Examples for r2resize}{

More examples and demo pages are located at this link -
\url{https://rpkg.net/package/r2resize}.
}

\examples{

r2resize::splitCard(
  "Sample text",
  "Sample text 2"
)


r2resize::splitCard(
  "Sample r2symbols 1",
  "Sample nextGen 1",
  bg.right.color = "white",
  bg.left.color = "lightgray",
  position = "vertical"
)

r2resize::splitCard(
  "Sample shinyStorePlus",
  "Sample nextGen 1",
  bg.right.color = "white",
  bg.left.color = "lightgray",
  border.color = "black",
  text.left.color = "black",
  text.right.color = "black",
  position = "vertical"
)

r2resize::splitCard(
  "Sample sciRmdTheme 1",
  "Sample nextGen 1",
  bg.right.color = "white",
  bg.left.color = "lightgray",
  border.color = "gray",
  text.left.color = "black",
  text.right.color = "black",
  position = "horizontal"
)

}
