% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_title.R
\name{rtf_subline}
\alias{rtf_subline}
\title{Add Subline Attributes to Table}
\usage{
rtf_subline(
  tbl,
  text,
  text_font = 1,
  text_format = NULL,
  text_font_size = 12,
  text_color = NULL,
  text_background_color = NULL,
  text_justification = "l",
  text_indent_first = 0,
  text_indent_left = 0,
  text_indent_right = 0,
  text_indent_reference = "table",
  text_space = 1,
  text_space_before = 180,
  text_space_after = 180,
  text_convert = TRUE
)
}
\arguments{
\item{tbl}{A data frame.}

\item{text}{A character vector of subline}

\item{text_font}{Text font type. Default is 1 for Times New Roman. To vary text font type
by column, use numeric vector with length of vector equal to number of
columns displayed e.g. c(1,2,3).All possible input can be found
in \code{r2rtf:::font_type()$type}.}

\item{text_format}{Text format type. Default is NULL for normal. Combination of format type
are permitted as input for e.g. "ub" for bold and underlined text. To vary
text format by column, use character vector with length of vector equal to
number of columns displayed e.g. c("i","u","ib"). All possible input
can be found in \code{r2rtf:::font_format()$type}.}

\item{text_font_size}{Text font size. Default is 9. To vary text font size by column, use
numeric vector with length of vector equal to number of columns
displayed e.g. c(9,20,40).}

\item{text_color}{Text color type. Default is NULL for black. To vary text color by column,
use character vector with length of vector equal to number of columns
displayed e.g. c("white","red","blue"). All possible input can be found
in \code{grDevices::colors()}.}

\item{text_background_color}{Text background color type. Default is NULL for white. To vary
text color by column, use character vector with length of vector
equal to number of columns displayed e.g. c("white","red","blue").
All possible input can be found in \code{grDevices::colors()}.}

\item{text_justification}{Justification type for text. Default is "c" for center justification.
To vary text justification by column, use character vector with
length of vector equal to number of columns displayed e.g. c("c","l","r").
All possible input can be found in \code{r2rtf:::justification()$type}.}

\item{text_indent_first}{A value of text indent in first line.}

\item{text_indent_left}{A value of text left indent.}

\item{text_indent_right}{A value of text right indent.}

\item{text_indent_reference}{The reference start point of text indent. Accept \code{table} or \code{page_margin}}

\item{text_space}{Line space between paragraph in twips. Default is 0.}

\item{text_space_before}{Line space before a paragraph in twips. Default is 15.}

\item{text_space_after}{Line space after a paragraph in twips. Default is 15.}

\item{text_convert}{A logical value to convert special characters. Default is TRUE.}
}
\value{
the same data frame \code{tbl} with additional attributes for table title
}
\description{
Add subline attributes to the object
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Define title attributes of \code{tbl} based on the input.
   \item Return \code{tbl}.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

