% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_border.R
\name{update_border_first}
\alias{update_border_first}
\title{Update First Border Line Based on Page Information}
\usage{
update_border_first(tbl)
}
\arguments{
\item{tbl}{A data frame}
}
\value{
a data frame \code{tbl} with updated top border type and top border color type attributes
}
\description{
Update first border line type and color type based on page information.
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item \code{tbl} is a data frame.
   \item Return a data frame \code{tbl} with updated top border type and top border color type attributes.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
library(dplyr)
tbl <- iris[c(1:3, 51:54), ] \%>\%
  rtf_body(page_by = "Species") \%>\%
  r2rtf:::update_border_first()
}
