% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcoxon_test.R
\name{wilcoxon_test}
\alias{wilcoxon_test}
\alias{to_SPSS.wilcoxon_test_SPSS}
\alias{print.wilcoxon_test_SPSS}
\alias{wilcoxonTest}
\title{Wilcoxon Signed Rank and Rank Sum Tests}
\usage{
wilcoxon_test(data, variables, group = NULL, exact = FALSE)

\method{to_SPSS}{wilcoxon_test_SPSS}(
  object,
  statistics = c("test", "ranks"),
  version = r2spss_options$get("version"),
  digits = NULL,
  ...
)

\method{print}{wilcoxon_test_SPSS}(
  x,
  statistics = c("ranks", "test"),
  version = r2spss_options$get("version"),
  digits = 2:3,
  ...
)

wilcoxonTest(data, variables, group = NULL, exact = FALSE)
}
\arguments{
\item{data}{a data frame containing the variables.}

\item{variables}{a character vector specifying numeric variable(s) to be
used.  If \code{group} is \code{NULL}, the Wilcoxon signed rank test is
performed and this should be a character vector specifying two numeric
variables which contain the paired observations.  If a grouping variable is
specified in \code{group}, the Wilcoxon rank sum test is performed and this
should be a character string specifying the numeric variable of interest.}

\item{group}{a character string specifying a grouping variable for the
Wilcoxon rank sum test, or \code{NULL}.}

\item{exact}{a logical indicating whether the Wilcoxon rank sum test
should also return the p-value of the exact test.  The default is
\code{FALSE}.  Note that the p-value of the asymptotic test is always
returned.}

\item{object, x}{an object of class \code{"wilcoxon_test_SPSS"} as returned
by function \code{wilcoxon_test}.}

\item{statistics}{a character string or vector specifying which SPSS tables
to produce.  Available options are \code{"ranks"} for a summary of the ranks
and \code{"test"} for test results.  For the \code{to_SPSS} method, only one
option is allowed (the default is the table of test results), but the
\code{print} method allows several options (the default is to print all
tables).}

\item{version}{a character string specifying whether the table should
mimic the content and look of recent SPSS versions (\code{"modern"}) or
older versions (<24; \code{"legacy"}).  The main difference in terms of
content is that small p-values are displayed differently.}

\item{digits}{for the \code{to_SPSS} method, an integer giving the number
of digits after the comma to be printed in the SPSS table.  For the
\code{print} method, this should be an integer vector of length 2, with the
first element corresponding to the number of digits in table with the
summary of the ranks, and the second element corresponding to the number of
digits in the table for the test.}

\item{\dots}{additional arguments to be passed down to
\code{\link{format_SPSS}}.}
}
\value{
An object of class \code{"wilcoxon_test_SPSS"} with the following
components:
\describe{
  \item{\code{statistics}}{a data frame containing the relevant information
  on the ranks.}
  \item{\code{test}}{a list containing the results of the Wilcoxon signed
  rank test (only paired-sample test).}
  \item{\code{variables}}{a character vector containing the name(s) of the
  relevant numeric variable(s).}
  \item{\code{n}}{an integer giving the number of observations (only
  paired-sample test).}
  \item{\code{u}}{numeric; the Mann-Whitney U test statistic (only
  independent-samples test).}
  \item{\code{w}}{numeric; the Wilcoxon rank sum test statistic (only
  independent-samples test).}
  \item{\code{asymptotic}}{a list containing the results of the Wilcoxon
  rank sum test using the normal approximation (only independent-samples
  test).}
  \item{\code{exact}}{if requested, the corresponding p-value of the exact
  Wilcoxon rank sum test test (only independent-samples test).}
  \item{\code{group}}{a character string containing the name of the
  grouping variable (only independent-samples test).}
  \item{\code{type}}{a character string giving the type of Wilcoxon test
  performed \code{"paired"} or \code{"independent"}).}
}

The \code{to_SPSS} method returns an object of class \code{"SPSS_table"}
which contains all relevant information in the required format to produce
the LaTeX table.  See \code{\link{to_latex}} for possible components and
how to further customize the LaTeX table based on the returned object.

The \code{print} method produces a LaTeX table that mimics the look of SPSS
output.
}
\description{
Perform a Wilcoxon signed rank test for a paired sample or a Wilcoxon rank
sum test for independent samples on variables of a data set.  The output
is printed as a LaTeX table that mimics the look of SPSS output.
}
\details{
The \code{print} method first calls the \code{to_SPSS} method followed
by \code{\link{to_latex}}.  Further customization can be done by calling
those two functions separately, and modifying the object returned by
\code{to_SPSS}.
}
\note{
The Wilcoxon rank sum test also reports the value of the equivalent
Mann-Whitney U test statistic.

LaTeX tables that mimic recent versions of SPSS (\code{version = "modern"})
may require several LaTeX compilations to be displayed correctly.
}
\examples{
## paired sample

# load data
data("Exams")

# test whether grades differ between the
# regular exam and the resit
wilcoxon_test(Exams, c("Regular", "Resit"))


## independent samples

# load data
data("Eredivisie")

# test whether market values differ between Dutch and foreign
# players
wilcoxon_test(Eredivisie, "MarketValue", group = "Foreign")

}
\author{
Andreas Alfons
}
\keyword{htest}
