% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{m_add_models_as_frames}
\alias{m_add_models_as_frames}
\title{Create and add model to viewer}
\usage{
m_add_models_as_frames(id, data, format)
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{data}{Path of input data path or a vector of data.}

\item{format}{Input format (see
\url{http://3dmol.csb.pitt.edu/doc/types.html#FileFormats}).}
}
\value{
R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
Create and add model to viewer. Given multimodel file and its format,
different atomlists are stored in model's frame
property and model's atoms are set to the 0th frame
}
\examples{
library(r3dmol)

r3dmol() \%>\%
  m_add_models_as_frames(data = xyz_multiple, format = "xyz") \%>\%
  m_animate(options = list(loop = "forward", reps = 1)) \%>\%
  m_set_style(style = list(stick = list(colorscheme = "magentaCarbon"))) \%>\%
  m_zoom_to()
}
