% Generated by roxygen2 (4.0.1): do not edit by hand
\name{SSplotCatch}
\alias{SSplotCatch}
\title{Plot catch related quantities.}
\usage{
SSplotCatch(replist, subplots = 1:15, add = FALSE, areas = 1,
  plot = TRUE, print = FALSE, type = "l", fleetlty = 1, fleetpch = 1,
  fleetcols = "default", fleetnames = "default", lwd = 3,
  areacols = "default", areanames = "default", minyr = NULL,
  maxyr = NULL, annualcatch = TRUE, forecastplot = TRUE,
  plotdir = "default", showlegend = TRUE, legendloc = "topleft",
  order = "default", xlab = "Year", labels = c("Harvest rate/Year",
  "Continuous F", "Landings", "Total catch", "Predicted Discards",
  "Discard fraction", "(mt)", "(numbers x1000)", "Observed and expected",
  "aggregated across seasons"), catchasnumbers = NULL, catchbars = TRUE,
  addmax = TRUE, ymax = NULL, pwidth = 7, pheight = 7, punits = "in",
  res = 300, ptsize = 12, cex.main = 1, verbose = TRUE)
}
\arguments{
\item{replist}{List created by \code{SS_output}}

\item{subplots}{Vector controlling which subplots to create}

\item{add}{Add to existing plot? (not yet implemented)}

\item{areas}{Optional subset of areas to plot for spatial models}

\item{plot}{Plot to active plot device?}

\item{print}{Print to PNG files?}

\item{type}{Type parameter passed to plot function. Default "l" is lines
only.  Other options include "o" for overplotting points on lines.}

\item{fleetlty}{Vector of line type by fleet}

\item{fleetpch}{Vector of plot character by fleet}

\item{fleetcols}{Vector of colors by fleet}

\item{fleetnames}{Optional replacement for fleenames used in data file}

\item{lwd}{Line width}

\item{areacols}{Vector of colors by area. Default uses rich.colors by Arni
Magnusson}

\item{areanames}{Names for areas. Default is to use Area1, Area2,...}

\item{minyr}{Optional input for minimum year to show in plots}

\item{maxyr}{Optional input for maximum year to show in plots}

\item{annualcatch}{Include plot of catch aggregated across seasons within
each year}

\item{forecastplot}{Add points from forecast years}

\item{plotdir}{Directory where PNG or PDF files will be written. By default
it will be the directory where the model was run.}

\item{showlegend}{Put legend on plot}

\item{legendloc}{Location of legend (see ?legend for more info)}

\item{order}{Optional input to change the order of fleets in stacked plots.}

\item{xlab}{x-label for all plots}

\item{labels}{Vector of labels for plots (titles and axis labels)}

\item{catchasnumbers}{Is catch in numbers instead of biomass? Should be set
automatically if set to NULL. If fleets include a mix of biomass and
numbers, then catch plots should be interpreted carefully.}

\item{catchbars}{Show catch by fleet as barplot instead of stacked polygons?
(default=TRUE)}

\item{addmax}{Add a point on the y-axis for the maximum catch (default=TRUE)}

\item{ymax}{Optional input for ymax value (can be used to add or subtract
white space at the top of the figure)}

\item{pwidth}{Width of plot written to PNG file}

\item{pheight}{Height of plot written to PNG file}

\item{punits}{Units for PNG file}

\item{res}{Resolution for PNG file}

\item{ptsize}{ptsize for PNG file}

\item{cex.main}{Character expansion for plot titles}

\item{verbose}{Report progress to R console?}
}
\description{
Plot catch related quantities from Stock Synthesis output. Plots include
harvest rate, continuous F, landings, and discard fraction.
}
\author{
Ian Taylor, Ian Stewart
}
\seealso{
\code{\link{SS_plots}}, \code{\link{SS_output}}
}
\keyword{aplot}
\keyword{hplot}

