% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplotDiscard.R
\name{SSplotDiscard}
\alias{SSplotDiscard}
\title{Plot fit to discard fraction.}
\usage{
SSplotDiscard(replist, subplots = 1:2, plot = TRUE, print = FALSE,
  plotdir = "default", fleets = "all", fleetnames = "default",
  datplot = FALSE, labels = c("Year", "Discard fraction",
  "Total discards", "for"), yhi = 1, ymax = NULL, col1 = "blue",
  col2 = "black", pwidth = 6.5, pheight = 5, punits = "in",
  res = 300, ptsize = 10, cex.main = 1, verbose = TRUE)
}
\arguments{
\item{replist}{List created by \code{\link{SS_output}}}

\item{subplots}{Vector of which plots to make (1 = data only, 2 = with fit).
If \code{plotdat = FALSE} then subplot 1 is not created, regardless of
choice of \code{subplots}.}

\item{plot}{Plot to active plot device?}

\item{print}{Print to PNG files?}

\item{plotdir}{Directory where PNG files will be written. by default it will
be the directory where the model was run.}

\item{fleets}{Optional vector to subset fleets for which plots will be made}

\item{fleetnames}{Optional replacement for fleenames used in data file}

\item{datplot}{Make data-only plot of discards? This can override the choice
of \code{subplots}.}

\item{labels}{Vector of labels for plots (titles and axis labels)}

\item{yhi}{Maximum y-value which will always be included in the plot
(all data included regardless). Default = 1 so that discard fractions are always
plotted on a 0-1 range, but total discard amounts which are greater than this value
will exceed it.}

\item{ymax}{Optional maximum y-value to include (useful if upper tails on
discard amounts are very high)}

\item{col1}{First color to use in plot (for expected values)}

\item{col2}{Second color to use in plot (for observations and intervals)}

\item{pwidth}{Width of plot}

\item{pheight}{Height of plot}

\item{punits}{Units for PNG file}

\item{res}{Resolution for PNG file}

\item{ptsize}{Point size for PNG file}

\item{cex.main}{Character expansion for plot titles}

\item{verbose}{Report progress to R GUI?}
}
\description{
Plot fit to discard fraction from Stock Synthesis output file.
}
\seealso{
\code{\link{SS_plots}}
}
\author{
Ian G. Taylor, Ian J. Stewart, Robbie L. Emmet
}
