% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplotPars.R
\name{SSplotPars}
\alias{SSplotPars}
\title{Plot distributions of priors, posteriors, and estimates.}
\usage{
SSplotPars(replist, xlab = "Parameter value", ylab = "Density",
  showmle = TRUE, showpost = TRUE, showprior = TRUE,
  showinit = TRUE, showdev = FALSE, showlegend = TRUE,
  fitrange = FALSE, xaxs = "i", xlim = NULL, ylim = NULL,
  verbose = TRUE, nrows = 3, ncols = 3, ltyvec = c(1, 1, 3, 4),
  colvec = c("blue", "red", "black", "gray60", rgb(0, 0, 0, 0.5)),
  new = TRUE, add = FALSE, pdf = FALSE, pwidth = 6.5,
  pheight = 5, punits = "in", ptsize = 10, returntable = FALSE,
  strings = c(), exact = FALSE, newheaders = NULL)
}
\arguments{
\item{replist}{List produced by \code{\link{SS_output}}.}

\item{xlab}{Label on horizontal axis.}

\item{ylab}{Label on vertical axis.}

\item{showmle}{Show MLE estimate and asymptotic variance estimate with blue
lines?}

\item{showpost}{Show posterior distribution as bar graph if MCMC results
are available in \code{replist}?}

\item{showprior}{Show prior distribution as black line?}

\item{showinit}{Show initial value as red triangle?}

\item{showdev}{Include devs in the plot?}

\item{showlegend}{Show the legend?}

\item{fitrange}{Fit range tightly around MLE & posterior distributions,
instead of full parameter range?}

\item{xaxs}{Parameter input for x-axis. See \code{?par} for more info.}

\item{xlim}{Optional x-axis limits to be applied to all plots.
Otherwise, limits are based on the model results.}

\item{ylim}{Optional y-axis limits to be applied to all plots.
Otherwise, limits are based on the model results.}

\item{verbose}{Controls amount of text output (maybe).}

\item{nrows}{How many rows in multi-figure plot.}

\item{ncols}{How many columns in multi-figure plot.}

\item{ltyvec}{Vector of line types used for lines showing MLE and prior
distributions and the median of the posterior distribution.}

\item{colvec}{Vector of colors used for lines and polygons showing MLE,
initial value, prior, posterior, and median of the posterior.}

\item{new}{Open new window for plotting?}

\item{add}{Add to existing plot?}

\item{pdf}{Write to PDF file instead of R GUI?}

\item{pwidth}{Default width of plots printed to files in units of
\code{punits}. Default=7.}

\item{pheight}{Default height width of plots printed to files in units of
\code{punits}. Default=7.}

\item{punits}{Units for \code{pwidth} and \code{pheight}. Can be "px"
(pixels), "in" (inches), "cm" or "mm". Default="in".}

\item{ptsize}{Point size for plotted text in plots printed to files (see
help("png") in R for details). Default=12.}

\item{returntable}{Return table of parameter info? Default=FALSE.}

\item{strings}{Subset parameters included in the plot using substring from
parameter names (i.e. "SR" will get "SR_LN(R0)" and "SR_steep" if they are both
estimated quantities in this model).}

\item{exact}{Should strings input match parameter names exactly?  Otherwise
substrings are allowed.}

\item{newheaders}{Optional vector of headers for each panel to replace the
parameter names.}
}
\description{
Make multi-figure plots of prior, posterior, and estimated asymptotic
parameter distributions. MCMC not required to make function work.
}
\examples{

\dontrun{
pars <- SSplotPars(dir='c:/SS/Simple/')

# strings can be partial match
pars <- SSplotPars(dir='c:/SS/Simple/',strings=c("steep"))
}

}
\author{
Ian G. Taylor, Cole C. Monnahan
}
