% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_sharedGenerics.R
\name{Generics functions}
\alias{Generics functions}
\alias{setBalloon}
\alias{setDataProvider}
\alias{setTitle}
\alias{setType}
\alias{setGraph}
\alias{addGuide}
\alias{setText}
\alias{setValueAxis}
\title{General shared generic methods}
\usage{
setBalloon(.Object, amBalloon = NULL, ...)

setDataProvider(.Object, dataProvider, keepNA = TRUE)

setTitle(.Object, title)

setType(.Object, type)

setGraph(.Object, graph = NULL, ...)

addGuide(.Object, guide = NULL, ...)

setText(.Object, text)

setValueAxis(.Object, valueAxis = NULL, ...)
}
\arguments{
\item{.Object}{\linkS4class{AmObject}.}

\item{amBalloon}{\linkS4class{AmBalloon}.}

\item{...}{Other properties.}

\item{dataProvider}{\code{data.frame}.}

\item{keepNA}{\code{logical}, default set to \code{TRUE}.
Indicates if \code{NULL} values have to be kept or ignored.}

\item{title}{\code{character}.}

\item{type}{\code{character}.}

\item{graph}{\linkS4class{AmGraph}.}

\item{guide}{\linkS4class{Guide}.}

\item{text}{\code{character}.}

\item{valueAxis}{\linkS4class{ValueAxis}.}
}
\value{
An updated 'AmObject'.
}
\description{
These methods are shared by at least two different classes
}
\details{
Be cautious when using one of these functions since they have several signatures (S4).

setBalloon is shared by AmChart and AmStockChart.

setDataProvider(..) is shared by AmGraph and DataSet.

setTitle(...) is Shared by AmGraph and ValueAxis.

setType(...) is shared by AmGraph and AmChart.

setGraph(...) is shared by AmChart and ChartScrollbar.

addGuide(...) is shared by AxisBase and AmChart.

setText(...) is shared by Title and Label.

setValueAxis(...) is shared by AmChart(type = "gantt"), TrendLine and Guide.
}
