% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildFPGrowth.R
\name{buildFPGrowth}
\alias{buildFPGrowth}
\title{Build classifier function (FP-Growth-based)}
\usage{
buildFPGrowth(train, className = NULL)
}
\arguments{
\item{train}{\code{data.frame} or \code{transactions} from \code{arules} with input data}

\item{className}{column name with the target class - default is the last column}
}
\value{
list with parameters and model as data.frame with rules
}
\description{
Automatic build of the classification model using the FP-Growth algorithm
}
\examples{
library("rCBA")
data("iris")

output <- rCBA::buildFPGrowth(iris[sample(nrow(iris), 50),], "Species")
model <- output$model

predictions <- rCBA::classification(iris, model)
table(predictions)
sum(iris$Species==predictions, na.rm=TRUE) / length(predictions)

}
