% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohort.R
\name{build_cohort}
\alias{build_cohort}
\title{Converts a longitudinal data set from e.g. \code{prev_terms} to a cohort dataset.
The dataset has a single row for each patient and includes only patients in the numerator or 
denominator for whichever cohort type is chosen. Columns are added for start and end dates and 
for start and end times as integer differences from the cohort start date. A binary column is 
added for membership of the case group.   All patients
with start date > end date are removed from the dataset.}
\usage{
build_cohort(dat, cohort_type = c("incid", "prev"), cohort_start, cohort_end,
  diagnosis_start = "eventdate")
}
\arguments{
\item{dat}{dataframe as output from a call to \code{prev_terms}}

\item{cohort_type}{character either 'incid' or 'prev'.  This selects the numerators and 
denominators for that type of cohort}

\item{cohort_start}{ISO date character string for the start of the cohort}

\item{cohort_end}{ISO date character string for the end of the cohort}

\item{diagnosis_start}{character string for the name of the diagnosis variable used to define the 
start dates, or NULL if the diagnosis date is not to be included in the definition 
of start dates.}
}
\description{
Converts a longitudinal data set from e.g. \code{prev_terms} to a cohort dataset.
The dataset has a single row for each patient and includes only patients in the numerator or 
denominator for whichever cohort type is chosen. Columns are added for start and end dates and 
for start and end times as integer differences from the cohort start date. A binary column is 
added for membership of the case group.   All patients
with start date > end date are removed from the dataset.
}

