% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gediDownload.R
\name{gediDownload}
\alias{gediDownload}
\title{Download GEDI data}
\usage{
gediDownload(filepath, outdir = NULL, overwrite = FALSE, buffer_size = 512)
}
\arguments{
\item{filepath}{Vector object; path to the GEDI data}

\item{outdir}{Vector object, output directory for downloading GEDI data, default tempdir()}

\item{overwrite}{logical; overwrite file if they already exists in destination, default FALSE}

\item{buffer_size}{integer; the size of download chunk in KB to hold in memory before writing to file, default 512.}
}
\value{
No return value on success, on failure it will \code{stop()}
}
\description{
Download GEDI data from LP DAAC Data Pool. Users will need to enter their
Earth Explore login Information for downloading the data.
}
\examples{
\dontrun{
# Set path to GEDI data
# herein we will only download xml metedata
filepath=c(paste0(
                 "https://e4ftl01.cr.usgs.gov/GEDI/GEDI02_B.001",
                 "/2019.04.18/GEDI02_B_2019108032534_O01961_T03911_02_001_01.h5.xml"
                 ),
          paste0("https://e4ftl01.cr.usgs.gov/GEDI/GEDI02_B.001",
                 "/2019.04.18/GEDI02_B_2019108045815_O01962_T01066_02_001_01.h5.xml"
                )
         )

# Set dir to download files to
outdir=tempdir()

# Create .netrc file
netrc = file.path(outdir, ".netrc")
netrc_conn <- file(netrc)

writeLines(c("machine urs.earthdata.nasa.gov",
            sprintf("login \%s", Sys.getenv("NASA_USER")),
            sprintf("password \%s", Sys.getenv("NASA_PASSWORD"))
), netrc_conn)

close(netrc_conn)

#' Downloading GEDI data
gediDownload(filepath,outdir)
}
}
\references{
Credits to Cole Krehbiel. Code adapted from <https://git.earthdata.nasa.gov/projects/LPDUR/repos/daac_data_download_r/browse/DAACDataDownload.R>
}
