% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.Report.r
\name{MVP.Report}
\alias{MVP.Report}
\title{MVP.Report}
\usage{
MVP.Report(MVP, col = c("#377EB8", "#4DAF4A", "#984EA3", "#FF7F00"),
  bin.size = 1e+06, bin.max = NULL, pch = 19, band = 1,
  cir.band = 0.5, H = 1.5, ylim = NULL, cex.axis = 1,
  plot.type = "b", multracks = FALSE, cex = c(0.5, 0.8, 1),
  r = 0.3, xlab = "Chromosome",
  ylab = expression(-log[10](italic(p))), xaxs = "i", yaxs = "r",
  outward = FALSE, threshold = NULL, threshold.col = "red",
  threshold.lwd = 1, threshold.lty = 2, amplify = TRUE,
  chr.labels = NULL, signal.cex = 0.8, signal.pch = 19,
  signal.col = "red", signal.line = NULL, cir.chr = TRUE,
  cir.chr.h = 1.3, chr.den.col = c("darkgreen", "yellow", "red"),
  cir.legend = TRUE, cir.legend.cex = 0.8, cir.legend.col = "grey45",
  LOG10 = TRUE, box = FALSE, conf.int.col = "grey",
  file.output = TRUE, outpath = getwd(), file.type = "jpg",
  dpi = 300, memo = "MVP", verbose = TRUE)
}
\arguments{
\item{MVP}{Data frame. Includes at least four columns. The first three columns are Marker ID, Chromosome ID, and Physical position. The fourth and following optional columns are P-values or effects of markers}

\item{col}{Vector or matrix. If 'col' is a vector, multiple-group GWAS results will use the same color scheme for plotting points on different Chromosomes. The vector length can be shorter than the number of Chromosomes and the colors will be used circularly. If 'col' is a matrix, multiple-group GWAS results will be drawn with colors from different rows, NA is allowed in the color matrix, e.g. col = matrix(c("grey30", "grey60", NA, "red", "blue", "green", "orange", NA, NA), 3, 3, byrow=T)}

\item{bin.size}{Number. Number of markers will be counted for each marker window and used for plotting marker density}

\item{bin.max}{Number. The maximum marker density value used for plotting marker density. Windows with marker density higher than 'bin.max' will use the same color as 'bin.max'}

\item{pch}{Number. Type of points, same as 'pch' in <plot> R function}

\item{band}{Number. The space among chromosomes.}

\item{cir.band}{Number. The space between circles when plotting Manhattan plot in circular manner}

\item{H}{Number. The height for each circle when plotting multiple-group GWAS results using Manhattan plot in circular manner}

\item{ylim}{Vector. The range of Y-axis when plotting Manhattan plot, same as "ylim" in <plot> R function}

\item{cex.axis}{Number. The size of Chromosome ID and labels when plotting Manhattan plot in circular manner}

\item{plot.type}{Character or Vector, options are "d", "c", "m", "q", and "b". If plot.type="d", marker density will be plotted; if plot.type="c", Manhattan plot in circular manner will be plotted; if plot.type="m", Manhattan plot in rectangular manner will be plotted; if plot.type="q", Q-Q plot will be plotted; if plot.type="b", both Manhattan plot and Q-Q plot will be plotted}

\item{multracks}{Logical value. If FALSE, multiple-group GWAS results will be plotted on multiple tracks; if TRUE, multiple-group GWAS results will be plotted on a single track}

\item{cex}{Number or Vector. The size of points. It is the same as "size" in <plot> R function. If given as a vector, the numbers are used to control the point size on Manhattan plot in circular manner, Manhattan plot in rectangular manner, and Q-Q plot, respectively}

\item{r}{Number. The radius of the inside circle when plotting Manhattan plot in circular manner}

\item{xlab}{Character. The label of X axis}

\item{ylab}{Character. The label of Y axis}

\item{xaxs}{Character. Options are "r", and "i". It is the same as "xaxs" in <plot> R function}

\item{yaxs}{Character. Options are "r", and "i". It is the same as "yaxs" in <plot> R function}

\item{outward}{Logical value. If TRUE, all points will be plotted from inside toward outside; otherwise, all points will be plotted from outside toward inside}

\item{threshold}{Number or Vector. The cutoff line on Manhattan plot, e.g. Bonfferoni correction. More than one significant line can be added onto one figure. If threshold=0 or NULL, the threshold line will not be added}

\item{threshold.col}{Character or Vector. The colors of threshold lines}

\item{threshold.lwd}{Number or Vector. The widths of threshold lines}

\item{threshold.lty}{Number or Vector. The type of threshold line}

\item{amplify}{Logical value. If TRUE, the points that passed the threshold line will be highlighted}

\item{chr.labels}{Vector. The labels for the Chromosome IDs on Manhattan plot in circular manner}

\item{signal.cex}{Number. If "amplify" is TRUE, "signal.cex" is used to set the size of significant points}

\item{signal.pch}{Number. If "amplify" is TRUE, users can set the type of significant points}

\item{signal.col}{Character. If "amplify" is TRUE, "signal.col" is used to set the color of significant points, if "signal.col" is NULL, the colors of significant points will not be changed}

\item{signal.line}{Number. The width of dotted lines used for marking significant points}

\item{cir.chr}{Logical value. If TRUE, a band that represents marker density information will be added onto Manhattan plot in circular manner}

\item{cir.chr.h}{Number. If "cir.chr=TRUE", it can be used to set the width of marker density band}

\item{chr.den.col}{Character or Vector or NULL. The colors for plotting marker density band on Manhattan plot. If "chr.den.col=NULL", it will use the colors in parameter 'col'}

\item{cir.legend}{Logical value. If TRUE, legends will be added on each circle of Manhattan plot in circular manner}

\item{cir.legend.cex}{Number. The size of legend on Manhattan plot in circular manner}

\item{cir.legend.col}{Character. The color of legends on Manhattan plot in circular manner}

\item{LOG10}{Logical value. If TRUE, the p values of GWAS results will be scaled by log10}

\item{box}{Logical value. If TRUE, the border line of Manhattan plot will be added}

\item{conf.int.col}{Character. The color of confidence interval on QQ-plot}

\item{file.output}{Logical value. If TRUE, the figures will be generated.}

\item{outpath}{Only when file.output = TRUE, determines the path of the output file}

\item{file.type}{Character. Options are jpg, pdf, and tiff}

\item{dpi}{Number. Dots per inch for .jpg and .tiff files}

\item{memo}{Character. A text marker on output files}

\item{verbose}{whether to print detail.}
}
\value{
Output files
}
\description{
MVP.Report
}
\examples{
data(pig60K, package = "rMVP")

MVP.Report(pig60K[,c(1:3, 5)], plot.type="m",
    threshold=0.05/nrow(pig60K), file.output=FALSE)

}
