% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_graphql.R
\name{search_graphql}
\alias{search_graphql}
\title{Perform a GraphQL Query to RCSB PDB}
\usage{
search_graphql(graphql_json_query)
}
\arguments{
\item{graphql_json_query}{A list containing the GraphQL query formatted as JSON. This list should include the `query` key with a value that represents the GraphQL query string.
The query string can specify various elements to retrieve, such as entry IDs, experimental methods, cell dimensions, etc.}
}
\value{
A parsed list containing the content of the response from the RCSB PDB, formatted as an R object. If the request fails, the function stops with an error message.
}
\description{
The `search_graphql` function sends a GraphQL query to the RCSB Protein Data Bank (PDB) using the provided JSON query format.
This function handles the HTTP request, sends the query, and processes the response, including error handling to ensure that the query executes successfully.
}
