% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{trading_new_order}
\alias{trading_new_order}
\title{Send Order to the Market}
\usage{
trading_new_order(
  connection,
  account,
  symbol,
  side,
  quantity,
  price,
  order_type = "Limit",
  time_in_force = "Day",
  iceberg = FALSE,
  expire_date = NULL,
  display_quantity = NULL
)
}
\arguments{
\item{connection}{S4. \strong{Mandatory} Formal rRofexConnection class object}

\item{account}{String. \strong{Mandatory} Account Number}

\item{symbol}{String. Use \code{\link{trading_instruments}} to see which symbols are available.}

\item{side}{String. \strong{Mandatory} Either:
\itemize{
\item \strong{Buy}
\item \strong{Sell}
}}

\item{quantity}{Numeric. \strong{Mandatory} Quantity of the order.}

\item{price}{Numeric. \strong{Mandatory} Price of the order.}

\item{order_type}{String. Type of order.
\itemize{
\item \strong{Limit} - Default. Limit order sets the maximum or minimum price at which you are willing to buy or sell.
}}

\item{time_in_force}{String. Specifies how long the order remains in effect. Absence of this field is interpreted as 'Day':
\itemize{
\item \strong{Day} - Day or session.
\item \strong{IOC} - Immediate or Cancel.
\item \strong{FOK} - Fill or Kill.
\item \strong{GTD} - Good Till Date.
}}

\item{iceberg}{Logical. If TRUE, then the order is 'iceberg'. FALSE as default.}

\item{expire_date}{String. \strong{Only for GDT orders}. Maturity date of the order, With format '\%Y-\%m-\%d'.}

\item{display_quantity}{Numeric. \strong{Only for Iceberg orders}. Indicate the disclosed quantity for the 'iceberg' order.}
}
\value{
If correct, it will load a tibble.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("maturing")}
The method \code{trading_new_order} is use to send orders.
}
\seealso{
Other order placements functions: 
\code{\link{trading_cancel_order}()}
}
\concept{order placements functions}
