% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{trading_login}
\alias{trading_login}
\title{API Log-in}
\usage{
trading_login(username, password, base_url)
}
\arguments{
\item{username}{String. User Name}

\item{password}{String. Password}

\item{base_url}{String. Which environment are you going to connect:
\itemize{
\item reMarkets: 'https://api.remarkets.primary.com.ar'
\item production: 'https://api.primary.com.ar'
\item xOMS: 'https://api.<BROKER>.xoms.com.ar'
}}
}
\value{
S4 rRofexConnection object.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("stable")}
Function that it is use to log-in into Primary trading API
}
\note{
\itemize{
\item reMarkets: Testing environment. For credentials go to \url{https://remarkets.primary.ventures}
\item production: Production environment. For credentials send an email to \email{mpi@primary.com.ar}
\item xOMS: Ask your broker about it.
}

Accessors:
You can use accessors to get information about the Object by using:
\itemize{
\item \code{token(conn)}
\item \code{base_url(conn)}
\item \code{login_date_time(conn)}
\item \code{agent(conn)}
\item \code{user_name(conn)}
}
}
\examples{
\dontrun{
conn <- trading_login(
username = "pepe",
password = "pepino",
base_url = "https://api.remarkets.primary.com.ar"
)
}
}
\concept{connection functions}
