% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSDI.R
\name{plotSDI}
\alias{plotSDI}
\title{plotSDI generates a plot of the network and SDI metrics on a geographic map.}
\usage{
plotSDI(
  g,
  variant = "",
  circle.size.scale = 1,
  circle.color = "red",
  edges = FALSE,
  edge.width.range = c(0.01, 0.5)
)
}
\arguments{
\item{g}{The igraph object to be plotted, whose vertices have attributes corresponding to SDI metrices.}

\item{variant}{The SDI variant with a prefix, such as "SDI_vuw", etc.}

\item{circle.size.scale}{Increase of decrease the size of circles drawn on nodes to represent SDI metric}

\item{circle.color}{Change color of circles}

\item{edges}{Whether to draw edges or not}

\item{edge.width.range}{If edges are to be drawn give a custom range of edge widths}
}
\value{
returns a ggplot2 plot
}
\description{
plotSDI generates a plot of the network and SDI metrics on a geographic map.
}
\examples{
TMSDI <- SDI(TurkiyeMigration.flows, TurkiyeMigration.nodes, variant="vuw")
plotSDI(TMSDI, variant="vuw", circle.size.scale=1)

}
