% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rspde_lme.R
\name{augment.rspde_lme}
\alias{augment.rspde_lme}
\alias{augment}
\title{Augment data with information from a \code{rspde_lme} object}
\usage{
\method{augment}{rspde_lme}(
  x,
  newdata = NULL,
  loc = NULL,
  mesh = FALSE,
  which_repl = NULL,
  se_fit = FALSE,
  conf_int = FALSE,
  pred_int = FALSE,
  level = 0.95,
  n_samples = 100,
  ...
)
}
\arguments{
\item{x}{A \code{rspde_lme} object.}

\item{newdata}{A \code{data.frame} or a \code{list} containing the covariates, the edge
number and the distance on edge for the locations to obtain the prediction. If \code{NULL}, the fitted values will be given for the original locations where the model was fitted.}

\item{loc}{Prediction locations. Can either be a \code{data.frame}, a \code{matrix} or a character vector, that contains the names of the columns of the coordinates of the locations. For models using \code{metric_graph} objects, plase use \code{edge_number} and \code{distance_on_edge} instead.}

\item{mesh}{Obtain predictions for mesh nodes? The graph must have a mesh, and either \code{only_latent} is set to TRUE or the model does not have covariates.}

\item{which_repl}{Which replicates to obtain the prediction. If \code{NULL} predictions
will be obtained for all replicates. Default is \code{NULL}.}

\item{se_fit}{Logical indicating whether or not a .se.fit column should be added to the augmented output. If TRUE, it only returns a non-NA value if type of prediction is 'link'.}

\item{conf_int}{Logical indicating whether or not confidence intervals for the fitted variable should be built.}

\item{pred_int}{Logical indicating whether or not prediction intervals for future observations should be built.}

\item{level}{Level of confidence and prediction intervals if they are constructed.}

\item{n_samples}{Number of samples when computing prediction intervals.}

\item{...}{Additional arguments. Expert use only.}
}
\value{
A \code{\link[tidyr:reexports]{tidyr::tibble()}} with columns:
\itemize{
\item \code{.fitted} Fitted or predicted value.
\item \code{.fittedlwrconf} Lower bound of the confidence interval, if conf_int = TRUE
\item \code{.fitteduprconf} Upper bound of the confidence interval, if conf_int = TRUE
\item \code{.fittedlwrpred} Lower bound of the prediction interval, if pred_int = TRUE
\item \code{.fitteduprpred} Upper bound of the prediction interval, if pred_int = TRUE
\item \code{.fixed} Prediction of the fixed effects.
\item \code{.random} Prediction of the random effects.
\item \code{.resid} The ordinary residuals, that is, the difference between observed and fitted values.
\item \code{.se_fit} Standard errors of fitted values, if se_fit = TRUE.
}
}
\description{
Augment accepts a model object and a dataset and adds information about each observation in the dataset. It includes
predicted values in the \code{.fitted} column, residuals in the \code{.resid} column, and standard errors for the fitted values in a \code{.se.fit} column.
It also contains the New columns always begin with a . prefix to avoid overwriting columns in the original dataset.
}
\seealso{
\link{glance.rspde_lme}
}
