% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_explore.R
\name{get_explore}
\alias{get_explore}
\title{Explore segments within a bounded area}
\usage{
get_explore(
  stoken,
  bounds,
  activity_type = "riding",
  max_cat = NULL,
  min_cat = NULL
)
}
\arguments{
\item{stoken}{A \code{\link[httr]{config}} object created using the \code{\link{strava_oauth}} function}

\item{bounds}{chr string representing the comma separated list of bounding box corners 'sw.lat,sw.lng,ne.lat,ne.lng' or 'south, west, north, east', see the example}

\item{activity_type}{chr string indicating activity type, "riding" or "running"}

\item{max_cat}{numeric indicating the maximum climbing category}

\item{min_cat}{numeric indicating the minimum climbing category}
}
\value{
Data from an API request.
}
\description{
Explore segments within a bounded area
}
\details{
Requires authentication stoken using the \code{\link{strava_oauth}} function and a user-created API on the strava website.
}
\examples{
\dontrun{
# create authentication token
# requires user created app name, id, and secret from Strava website
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, 
	app_secret, cache = TRUE))

bnds <- "37.821362, -122.505373, 37.842038, -122.465977"
get_explore(stoken, bnds)
}
}
\concept{token}
