/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.python.core.ArgParser;
import org.python.core.ClasspathPyImporter$PyExposer;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.core.util.importer;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExposedType(name="ClasspathPyImporter")
public class ClasspathPyImporter
extends importer<String> {
    public static final String PYCLASSPATH_PREFIX = "__pyclasspath__/";
    public static final PyType TYPE;
    private Map<String, InputStream> entries = Generic.map();
    private String path;

    public ClasspathPyImporter(PyType subType) {
        super(subType);
    }

    public ClasspathPyImporter() {
    }

    @ExposedNew
    final void ClasspathPyImporter___init__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("__init__", args, kwds, new String[]{"path"});
        String path = ap.getString(0);
        if (path == null || !path.startsWith(PYCLASSPATH_PREFIX)) {
            throw Py.ImportError("path isn't for classpath importer");
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        this.path = path;
    }

    final PyObject ClasspathPyImporter_find_module(String fullname, String path) {
        return this.importer_find_module(fullname, path);
    }

    final PyObject ClasspathPyImporter_load_module(String fullname) {
        return this.importer_load_module(fullname);
    }

    @Override
    protected boolean isAcceptableBytecode(String searchPath, String entry) {
        return true;
    }

    @Override
    protected importer.Bundle makeBundle(String fullFilename, String entry) {
        InputStream is = this.entries.remove(entry);
        return new importer.Bundle(is){

            public void close() {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    throw Py.JavaError(e);
                }
            }
        };
    }

    @Override
    protected String makeEntry(String fullFilename) {
        if (this.entries.containsKey(fullFilename)) {
            return fullFilename;
        }
        InputStream is = null;
        ClassLoader classLoader = Py.getSystemState().getClassLoader();
        if (classLoader != null) {
            Py.writeDebug("import", "trying " + fullFilename + " in sys class loader");
            is = classLoader.getResourceAsStream(fullFilename);
        }
        if (is == null) {
            Py.writeDebug("import", "trying " + fullFilename + " in context class loader");
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(fullFilename);
        }
        if (is != null) {
            this.entries.put(fullFilename, is);
            return fullFilename;
        }
        return null;
    }

    @Override
    protected String makeFilename(String fullname) {
        return this.path.replace(PYCLASSPATH_PREFIX, "") + fullname.replace('.', '/');
    }

    @Override
    protected String makeFilePath(String fullname) {
        return this.path + fullname.replace('.', '/');
    }

    @Override
    protected String makePackagePath(String fullname) {
        return this.path;
    }

    @Override
    protected String getSeparator() {
        return "/";
    }

    static {
        PyType.addBuilder(ClasspathPyImporter.class, new ClasspathPyImporter$PyExposer());
        TYPE = PyType.fromClass(ClasspathPyImporter.class);
    }
}

