/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBaseString;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyUnicode;
import org.python.core.StringSubsequenceIterator;
import org.python.core.imp;

public class codecs {
    public static final String BACKSLASHREPLACE = "backslashreplace";
    public static final String IGNORE = "ignore";
    public static final String REPLACE = "replace";
    public static final String XMLCHARREFREPLACE = "xmlcharrefreplace";
    private static char Py_UNICODE_REPLACEMENT_CHARACTER = (char)65533;
    private static PyList searchPath;
    private static PyStringMap searchCache;
    private static PyStringMap errorHandlers;
    private static final Object INIT_LOCK;
    private static String default_encoding;
    private static boolean import_encodings_called;
    static char[] hexdigits;
    public static char[] utf7_special;
    private static final String B64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static byte[] utf8_code_length;
    private static char[] hexdigit;

    public static String getDefaultEncoding() {
        return default_encoding;
    }

    public static void setDefaultEncoding(String encoding) {
        codecs.lookup(encoding);
        default_encoding = encoding;
    }

    public static PyObject lookup_error(String handlerName) {
        PyObject handler;
        codecs.registry_init();
        if (handlerName == null) {
            handlerName = "strict";
        }
        if ((handler = errorHandlers.__finditem__(handlerName.intern())) == null) {
            throw new PyException(Py.LookupError, "unknown error handler name '" + handlerName + "'");
        }
        return handler;
    }

    public static void register_error(String name, PyObject error) {
        codecs.registry_init();
        if (!error.isCallable()) {
            throw Py.TypeError("argument must be callable");
        }
        errorHandlers.__setitem__(name.intern(), error);
    }

    public static void register(PyObject search_function) {
        codecs.registry_init();
        if (!search_function.isCallable()) {
            throw Py.TypeError("argument must be callable");
        }
        searchPath.append(search_function);
    }

    public static PyTuple lookup(String encoding) {
        codecs.registry_init();
        PyString v = new PyString(codecs.normalizestring(encoding));
        PyObject result = searchCache.__finditem__(v);
        if (result != null) {
            return (PyTuple)result;
        }
        if (searchPath.__len__() == 0) {
            throw new PyException(Py.LookupError, "no codec search functions registered: can't find encoding");
        }
        PyObject iter = searchPath.__iter__();
        PyObject func = null;
        while ((func = iter.__iternext__()) != null) {
            result = func.__call__(v);
            if (result == Py.None) continue;
            if (result instanceof PyTuple && result.__len__() == 4) break;
            throw Py.TypeError("codec search functions must return 4-tuples");
        }
        if (func == null) {
            throw new PyException(Py.LookupError, "unknown encoding " + encoding);
        }
        searchCache.__setitem__(v, result);
        return (PyTuple)result;
    }

    private static String normalizestring(String string) {
        return string.toLowerCase().replace(' ', '-');
    }

    private static void import_encodings() {
        block3: {
            if (!import_encodings_called) {
                import_encodings_called = true;
                try {
                    imp.load("encodings");
                }
                catch (PyException exc) {
                    if (exc.type == Py.ImportError) break block3;
                    throw exc;
                }
            }
        }
    }

    public static PyObject decode(PyString v, String encoding, String errors) {
        encoding = encoding == null ? codecs.getDefaultEncoding() : codecs.normalizestring(encoding);
        if (errors != null) {
            errors = errors.intern();
        }
        if (encoding.equals("ascii")) {
            return new PyUnicode(codecs.PyUnicode_DecodeASCII(v.toString(), v.__len__(), errors), true);
        }
        PyObject decoder = codecs.getDecoder(encoding);
        PyObject result = null;
        result = errors != null ? decoder.__call__(v, new PyString(errors)) : decoder.__call__(v);
        if (!(result instanceof PyTuple) || result.__len__() != 2) {
            throw Py.TypeError("decoder must return a tuple (object,integer)");
        }
        return result.__getitem__(0);
    }

    private static PyObject getDecoder(String encoding) {
        PyTuple codecs2 = codecs.lookup(encoding);
        return codecs2.__getitem__(1);
    }

    public static String encode(PyString v, String encoding, String errors) {
        encoding = encoding == null ? codecs.getDefaultEncoding() : codecs.normalizestring(encoding);
        if (errors != null) {
            errors = errors.intern();
        }
        if (encoding.equals("latin-1")) {
            return codecs.PyUnicode_EncodeLatin1(v.toString(), v.__len__(), errors);
        }
        if (encoding.equals("ascii")) {
            return codecs.PyUnicode_EncodeASCII(v.toString(), v.__len__(), errors);
        }
        PyObject encoder = codecs.getEncoder(encoding);
        PyObject result = null;
        result = errors != null ? encoder.__call__(v, new PyString(errors)) : encoder.__call__(v);
        if (!(result instanceof PyTuple) || result.__len__() != 2) {
            throw Py.TypeError("encoder must return a tuple (object,integer)");
        }
        PyObject encoded = result.__getitem__(0);
        if (encoded instanceof PyString) {
            return encoded.toString();
        }
        throw Py.TypeError("decoder did not return a string/unicode object (type=" + encoded.getType().fastGetName() + ")");
    }

    private static PyObject getEncoder(String encoding) {
        PyTuple codecs2 = codecs.lookup(encoding);
        return codecs2.__getitem__(0);
    }

    public static PyObject strict_errors(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("strict_errors", args, kws, "exc");
        PyObject exc = ap.getPyObject(0);
        if (Py.isInstance(exc, Py.UnicodeDecodeError)) {
            throw new PyException(Py.UnicodeDecodeError, exc);
        }
        if (Py.isInstance(exc, Py.UnicodeEncodeError)) {
            throw new PyException(Py.UnicodeEncodeError, exc);
        }
        if (Py.isInstance(exc, Py.UnicodeTranslateError)) {
            throw new PyException(Py.UnicodeTranslateError, exc);
        }
        throw codecs.wrong_exception_type(exc);
    }

    public static PyObject ignore_errors(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("ignore_errors", args, kws, "exc");
        PyObject exc = ap.getPyObject(0);
        if (!codecs.isUnicodeError(exc)) {
            throw codecs.wrong_exception_type(exc);
        }
        PyObject end = exc.__getattr__("end");
        return new PyTuple(Py.java2py(""), end);
    }

    private static boolean isUnicodeError(PyObject exc) {
        return Py.isInstance(exc, Py.UnicodeDecodeError) || Py.isInstance(exc, Py.UnicodeEncodeError) || Py.isInstance(exc, Py.UnicodeTranslateError);
    }

    public static PyObject replace_errors(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("replace_errors", args, kws, "exc");
        PyObject exc = ap.getPyObject(0);
        if (Py.isInstance(exc, Py.UnicodeDecodeError)) {
            PyObject object = exc.__getattr__("object");
            if (!Py.isInstance(object, PyString.TYPE) || Py.isInstance(object, PyUnicode.TYPE)) {
                throw Py.TypeError("object attribute must be str");
            }
            PyObject end = exc.__getattr__("end");
            return new PyTuple(new PyUnicode(Py_UNICODE_REPLACEMENT_CHARACTER), end);
        }
        if (Py.isInstance(exc, Py.UnicodeEncodeError)) {
            PyObject object = exc.__getattr__("object");
            if (!Py.isInstance(object, PyUnicode.TYPE)) {
                throw Py.TypeError("object attribute must be unicode");
            }
            PyObject end = exc.__getattr__("end");
            return new PyTuple(Py.java2py("?"), end);
        }
        if (Py.isInstance(exc, Py.UnicodeTranslateError)) {
            PyObject end = exc.__getattr__("end");
            return new PyTuple(new PyUnicode(Py_UNICODE_REPLACEMENT_CHARACTER), end);
        }
        throw codecs.wrong_exception_type(exc);
    }

    public static PyObject xmlcharrefreplace_errors(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("xmlcharrefreplace_errors", args, kws, "exc");
        PyObject exc = ap.getPyObject(0);
        if (!Py.isInstance(exc, Py.UnicodeEncodeError)) {
            throw codecs.wrong_exception_type(exc);
        }
        int start = ((PyInteger)exc.__getattr__("start")).getValue();
        int end = ((PyInteger)exc.__getattr__("end")).getValue();
        String object = exc.__getattr__("object").toString();
        StringBuilder replacement = new StringBuilder();
        codecs.xmlcharrefreplace_internal(start, end, object, replacement);
        return new PyTuple(Py.java2py(replacement.toString()), exc.__getattr__("end"));
    }

    public static StringBuilder xmlcharrefreplace(int start, int end, String toReplace) {
        StringBuilder replacement = new StringBuilder();
        codecs.xmlcharrefreplace_internal(start, end, toReplace, replacement);
        return replacement;
    }

    private static void xmlcharrefreplace_internal(int start, int end, String object, StringBuilder replacement) {
        for (int i = start; i < end; ++i) {
            int base;
            int digits;
            replacement.append("&#");
            char cur = object.charAt(i);
            if (cur < '\n') {
                digits = 1;
                base = 1;
            } else if (cur < 'd') {
                digits = 2;
                base = 10;
            } else if (cur < '\u03e8') {
                digits = 3;
                base = 100;
            } else if (cur < '\u2710') {
                digits = 4;
                base = 1000;
            } else if (cur < '\u186a0') {
                digits = 5;
                base = 10000;
            } else if (cur < '\uf4240') {
                digits = 6;
                base = 100000;
            } else {
                digits = 7;
                base = 1000000;
            }
            while (digits-- > 0) {
                replacement.append((char)(48 + cur / base));
                cur = (char)(cur % base);
                base /= 10;
            }
            replacement.append(';');
        }
    }

    private static PyException wrong_exception_type(PyObject exc) {
        PyObject excClass = exc.__getattr__("__class__");
        PyObject className = excClass.__getattr__("__name__");
        return new PyException(Py.TypeError, "Don't know how to handle " + className + " in error callback");
    }

    public static PyObject backslashreplace_errors(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("backslashreplace_errors", args, kws, "exc");
        PyObject exc = ap.getPyObject(0);
        if (!Py.isInstance(exc, Py.UnicodeEncodeError)) {
            throw codecs.wrong_exception_type(exc);
        }
        int start = ((PyInteger)exc.__getattr__("start")).getValue();
        int end = ((PyInteger)exc.__getattr__("end")).getValue();
        String object = exc.__getattr__("object").toString();
        StringBuilder replacement = new StringBuilder();
        codecs.backslashreplace_internal(start, end, object, replacement);
        return new PyTuple(Py.java2py(replacement.toString()), exc.__getattr__("end"));
    }

    public static StringBuilder backslashreplace(int start, int end, String toReplace) {
        StringBuilder replacement = new StringBuilder();
        codecs.backslashreplace_internal(start, end, toReplace, replacement);
        return replacement;
    }

    private static void backslashreplace_internal(int start, int end, String object, StringBuilder replacement) {
        StringSubsequenceIterator iter = new StringSubsequenceIterator(object, start, end, 1);
        while (iter.hasNext()) {
            int c = (Integer)iter.next();
            replacement.append('\\');
            if (c >= 65536) {
                replacement.append('U');
                replacement.append(hexdigits[c >> 28 & 0xF]);
                replacement.append(hexdigits[c >> 24 & 0xF]);
                replacement.append(hexdigits[c >> 20 & 0xF]);
                replacement.append(hexdigits[c >> 16 & 0xF]);
                replacement.append(hexdigits[c >> 12 & 0xF]);
                replacement.append(hexdigits[c >> 8 & 0xF]);
            } else if (c >= 256) {
                replacement.append('u');
                replacement.append(hexdigits[c >> 12 & 0xF]);
                replacement.append(hexdigits[c >> 8 & 0xF]);
            } else {
                replacement.append('x');
            }
            replacement.append(hexdigits[c >> 4 & 0xF]);
            replacement.append(hexdigits[c & 0xF]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registry_init() {
        Object object = INIT_LOCK;
        synchronized (object) {
            if (searchPath != null) {
                return;
            }
            searchPath = new PyList();
            searchCache = new PyStringMap();
            errorHandlers = new PyStringMap();
            String[] builtinErrorHandlers = new String[]{"strict", IGNORE, REPLACE, XMLCHARREFREPLACE, BACKSLASHREPLACE};
            for (int i = 0; i < builtinErrorHandlers.length; ++i) {
                codecs.register_error(builtinErrorHandlers[i], Py.newJavaFunc(codecs.class, builtinErrorHandlers[i] + "_errors"));
            }
            codecs.import_encodings();
        }
    }

    private static boolean SPECIAL(char c, boolean encodeO, boolean encodeWS) {
        return c > '\u007f' || utf7_special[c] == '\u0001' || encodeWS && utf7_special[c] == '\u0002' || encodeO && utf7_special[c] == '\u0003';
    }

    private static char B64(int n) {
        return B64_CHARS.charAt(n & 0x3F);
    }

    private static boolean B64CHAR(char c) {
        return B64_CHARS.indexOf(c) != -1;
    }

    private static int UB64(char c) {
        return c == '+' ? 62 : (c == '/' ? 63 : (c >= 'a' ? c - 71 : (c >= 'A' ? c - 65 : c + 4)));
    }

    public static String PyUnicode_DecodeUTF7(String str, String errors) {
        int s = 0;
        int e = str.length();
        boolean inShift = false;
        int bitsInCharsleft = 0;
        long charsleft = 0L;
        boolean surrogate = false;
        char highOrderSurrogate = '\u0000';
        StringBuilder unicode = new StringBuilder(e);
        while (s < e) {
            char ch = str.charAt(s);
            if (inShift) {
                char outCh;
                if (ch == '-' || !codecs.B64CHAR(ch)) {
                    inShift = false;
                    ++s;
                    while (bitsInCharsleft >= 16) {
                        outCh = (char)(charsleft >> (bitsInCharsleft -= 16) & 0xFFFFL);
                        if (surrogate) {
                            s = codecs.insertReplacementAndGetResume(unicode, errors, "utf-7", str, s, s + 1, "code pairs are not supported");
                            surrogate = false;
                            continue;
                        }
                        if ('\udc00' <= outCh && outCh <= '\udfff') {
                            surrogate = true;
                            highOrderSurrogate = outCh;
                            continue;
                        }
                        unicode.append(outCh);
                    }
                    if (bitsInCharsleft >= 6) {
                        s = codecs.insertReplacementAndGetResume(unicode, errors, "utf-7", str, s, s + 1, "partial character in shift sequence");
                    }
                    if (bitsInCharsleft > 0 && (charsleft << 5 - bitsInCharsleft & 0x1FL) > 0L) {
                        s = codecs.insertReplacementAndGetResume(unicode, errors, "utf-7", str, s, s + 1, "non-zero padding bits in shift sequence");
                    }
                    if (ch == '-') {
                        if (s < e && str.charAt(s) == '-') {
                            unicode.append('-');
                            inShift = true;
                        }
                    } else if (codecs.SPECIAL(ch, false, false)) {
                        s = codecs.insertReplacementAndGetResume(unicode, errors, "utf-7", str, s, s + 1, "unexpected special character");
                    } else {
                        unicode.append(ch);
                    }
                } else {
                    charsleft = charsleft << 6 | (long)codecs.UB64(ch);
                    bitsInCharsleft += 6;
                    ++s;
                    while (bitsInCharsleft >= 16) {
                        outCh = (char)(charsleft >> (bitsInCharsleft -= 16) & 0xFFFFL);
                        if (surrogate) {
                            s = codecs.insertReplacementAndGetResume(unicode, errors, "utf-7", str, s, s + 1, "code pairs are not supported");
                            continue;
                        }
                        if ('\udc00' <= outCh && outCh <= '\udfff') {
                            surrogate = true;
                            highOrderSurrogate = outCh;
                            continue;
                        }
                        unicode.append(outCh);
                    }
                }
            } else if (ch == '+') {
                if (++s < e && str.charAt(s) == '-') {
                    ++s;
                    unicode.append('+');
                } else {
                    inShift = true;
                    bitsInCharsleft = 0;
                }
            } else if (codecs.SPECIAL(ch, false, false)) {
                s = codecs.insertReplacementAndGetResume(unicode, errors, "utf-7", str, s, s + 1, "unexpected special character");
            } else {
                unicode.append(ch);
                ++s;
            }
            if (!inShift || s != e) continue;
            s = codecs.insertReplacementAndGetResume(unicode, errors, "utf-7", str, s, s, "unterminated shift sequence");
        }
        return unicode.toString();
    }

    public static String PyUnicode_EncodeUTF7(String str, boolean encodeSetO, boolean encodeWhiteSpace, String errors) {
        int size = str.length();
        if (size == 0) {
            return "";
        }
        boolean inShift = false;
        int bitsleft = 0;
        int charsleft = 0;
        StringBuilder v = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            char ch = str.charAt(i);
            if (!inShift) {
                if (ch == '+') {
                    v.append('+');
                    v.append('-');
                    continue;
                }
                if (codecs.SPECIAL(ch, encodeSetO, encodeWhiteSpace)) {
                    charsleft = ch;
                    v.append('+');
                    for (bitsleft = 16; bitsleft >= 6; bitsleft -= 6) {
                        v.append(codecs.B64(charsleft >> bitsleft - 6));
                    }
                    inShift = bitsleft > 0;
                    continue;
                }
                v.append(ch);
                continue;
            }
            if (!codecs.SPECIAL(ch, encodeSetO, encodeWhiteSpace)) {
                v.append(codecs.B64(charsleft << 6 - bitsleft));
                charsleft = 0;
                bitsleft = 0;
                if (codecs.B64CHAR(ch) || ch == '-') {
                    v.append('-');
                }
                inShift = false;
                v.append(ch);
                continue;
            }
            bitsleft += 16;
            charsleft = charsleft << 16 | ch;
            while (bitsleft >= 6) {
                v.append(codecs.B64(charsleft >> bitsleft - 6));
                bitsleft -= 6;
            }
            if (bitsleft != 0) continue;
            if (i + 1 < size) {
                char ch2 = str.charAt(i + 1);
                if (codecs.SPECIAL(ch2, encodeSetO, encodeWhiteSpace)) continue;
                if (codecs.B64CHAR(ch2) || ch2 == '-') {
                    v.append('-');
                    inShift = false;
                    continue;
                }
                inShift = false;
                continue;
            }
            v.append('-');
            inShift = false;
        }
        if (bitsleft > 0) {
            v.append(codecs.B64(charsleft << 6 - bitsleft));
            v.append('-');
        }
        return v.toString();
    }

    public static String PyUnicode_DecodeUTF8(String str, String errors) {
        return codecs.PyUnicode_DecodeUTF8Stateful(str, errors, null);
    }

    public static String PyUnicode_DecodeUTF8Stateful(String str, String errors, int[] consumed) {
        int size = str.length();
        StringBuilder unicode = new StringBuilder(size);
        int i = 0;
        block7: while (i < size) {
            int ch = str.charAt(i);
            if (ch < 128) {
                unicode.append((char)ch);
                ++i;
                continue;
            }
            if (ch > 255) {
                i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + 1, "ordinal not in range(255)");
                continue;
            }
            byte n = utf8_code_length[ch];
            if (i + n > size) {
                if (consumed != null) break;
                i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + 1, "unexpected end of data");
                continue;
            }
            switch (n) {
                case 0: {
                    i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + 1, "unexpected code byte");
                    continue block7;
                }
                case 1: {
                    i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + 1, "internal error");
                    continue block7;
                }
                case 2: {
                    char ch1 = str.charAt(i + 1);
                    if ((ch1 & 0xC0) != 128) {
                        i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + 2, "invalid data");
                        continue block7;
                    }
                    if ((ch = ((ch & 0x1F) << 6) + (ch1 & 0x3F)) < 128) {
                        i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + 2, "illegal encoding");
                        continue block7;
                    }
                    unicode.appendCodePoint(ch);
                    break;
                }
                case 3: {
                    char ch1 = str.charAt(i + 1);
                    char ch2 = str.charAt(i + 2);
                    if ((ch1 & 0xC0) != 128 || (ch2 & 0xC0) != 128) {
                        i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + 3, "invalid data");
                        continue block7;
                    }
                    if ((ch = ((ch & 0xF) << 12) + ((ch1 & 0x3F) << 6) + (ch2 & 0x3F)) < 2048 || ch >= 55296 && ch < 57344) {
                        i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + 3, "illegal encoding");
                        continue block7;
                    }
                    unicode.appendCodePoint(ch);
                    break;
                }
                case 4: {
                    char ch1 = str.charAt(i + 1);
                    char ch2 = str.charAt(i + 2);
                    char ch3 = str.charAt(i + 3);
                    if ((ch1 & 0xC0) != 128 || (ch2 & 0xC0) != 128 || (ch3 & 0xC0) != 128) {
                        i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + 4, "invalid data");
                        continue block7;
                    }
                    if ((ch = ((ch & 7) << 18) + ((ch1 & 0x3F) << 12) + ((ch2 & 0x3F) << 6) + (ch3 & 0x3F)) < 65536 || ch > 0x10FFFF) {
                        i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + 4, "illegal encoding");
                        continue block7;
                    }
                    unicode.appendCodePoint(ch);
                    break;
                }
                default: {
                    i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + n, "unsupported Unicode code range");
                    continue block7;
                }
            }
            i += n;
        }
        if (consumed != null) {
            consumed[0] = i;
        }
        return unicode.toString();
    }

    public static String PyUnicode_EncodeUTF8(String str, String errors) {
        Charset utf8 = Charset.forName("UTF-8");
        ByteBuffer bbuf = utf8.encode(str);
        StringBuilder v = new StringBuilder(bbuf.limit());
        while (bbuf.remaining() > 0) {
            int val = bbuf.get();
            if (val < 0) {
                val = 256 + val;
            }
            v.appendCodePoint(val);
        }
        return v.toString();
    }

    public static String PyUnicode_DecodeASCII(String str, int size, String errors) {
        return codecs.PyUnicode_DecodeIntLimited(str, size, errors, "ascii", 128);
    }

    public static String PyUnicode_DecodeLatin1(String str, int size, String errors) {
        return codecs.PyUnicode_DecodeIntLimited(str, size, errors, "latin-1", 256);
    }

    private static String PyUnicode_DecodeIntLimited(String str, int size, String errors, String encoding, int limit) {
        StringBuilder v = new StringBuilder(size);
        String reason = "ordinal not in range(" + limit + ")";
        for (int i = 0; i < size; ++i) {
            char ch = str.charAt(i);
            if (ch < limit) {
                v.append(ch);
                continue;
            }
            i = codecs.insertReplacementAndGetResume(v, errors, encoding, str, i, i + 1, reason) - 1;
        }
        return v.toString();
    }

    public static String PyUnicode_EncodeASCII(String str, int size, String errors) {
        return codecs.PyUnicode_EncodeIntLimited(str, size, errors, "ascii", 128);
    }

    public static String PyUnicode_EncodeLatin1(String str, int size, String errors) {
        return codecs.PyUnicode_EncodeIntLimited(str, size, errors, "latin-1", 256);
    }

    private static String PyUnicode_EncodeIntLimited(String str, int size, String errors, String encoding, int limit) {
        String reason = "ordinal not in range(" + limit + ")";
        StringBuilder v = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            char ch = str.charAt(i);
            if (ch >= limit) {
                int nextGood;
                for (nextGood = i + 1; nextGood < size && str.charAt(nextGood) >= limit; ++nextGood) {
                }
                if (errors != null) {
                    if (errors.equals(IGNORE)) {
                        i = nextGood - 1;
                        continue;
                    }
                    if (errors.equals(REPLACE)) {
                        for (int j = i; j < nextGood; ++j) {
                            v.append('?');
                        }
                        i = nextGood - 1;
                        continue;
                    }
                    if (errors.equals(XMLCHARREFREPLACE)) {
                        v.append((CharSequence)codecs.xmlcharrefreplace(i, nextGood, str));
                        i = nextGood - 1;
                        continue;
                    }
                    if (errors.equals(BACKSLASHREPLACE)) {
                        v.append((CharSequence)codecs.backslashreplace(i, nextGood, str));
                        i = nextGood - 1;
                        continue;
                    }
                }
                PyObject replacement = codecs.encoding_error(errors, encoding, str, i, nextGood, reason);
                String replStr = replacement.__getitem__(0).toString();
                for (int j = 0; j < replStr.length(); ++j) {
                    if (replStr.charAt(j) < limit) continue;
                    throw Py.UnicodeEncodeError(encoding, str, i + j, i + j + 1, reason);
                }
                v.append(replStr);
                i = codecs.calcNewPosition(size, replacement) - 1;
                continue;
            }
            v.append(ch);
        }
        return v.toString();
    }

    public static int calcNewPosition(int size, PyObject errorTuple) {
        int newPosition = ((PyInteger)errorTuple.__getitem__(1)).getValue();
        if (newPosition < 0) {
            newPosition = size + newPosition;
        }
        if (newPosition > size || newPosition < 0) {
            throw Py.IndexError(newPosition + " out of bounds of encoded string");
        }
        return newPosition;
    }

    public static String PyUnicode_EncodeRawUnicodeEscape(String str, String errors, boolean modifed) {
        int size = str.length();
        StringBuilder v = new StringBuilder(str.length());
        for (int i = 0; i < size; ++i) {
            char ch = str.charAt(i);
            if (ch >= '\u0100' || modifed && (ch == '\n' || ch == '\\')) {
                v.append("\\u");
                v.append(hexdigit[ch >>> 12 & 0xF]);
                v.append(hexdigit[ch >>> 8 & 0xF]);
                v.append(hexdigit[ch >>> 4 & 0xF]);
                v.append(hexdigit[ch & 0xF]);
                continue;
            }
            v.append(ch);
        }
        return v.toString();
    }

    public static String PyUnicode_DecodeRawUnicodeEscape(String str, String errors) {
        int size = str.length();
        StringBuilder v = new StringBuilder(size);
        int i = 0;
        while (i < size) {
            int j;
            char ch = str.charAt(i);
            if (ch != '\\') {
                v.append(ch);
                ++i;
                continue;
            }
            int bs = i;
            while (i < size && (ch = str.charAt(i)) == '\\') {
                v.append(ch);
                ++i;
            }
            if ((i - bs & 1) == 0 || i >= size || ch != 'u') continue;
            v.setLength(v.length() - 1);
            ++i;
            int x = 0;
            int d = 0;
            for (j = 0; j < 4 && (d = Character.digit(ch = str.charAt(i + j), 16)) != -1; ++j) {
                x = (x << 4 & 0xFFFFFFF0) + d;
            }
            if (d == -1) {
                i = codecs.insertReplacementAndGetResume(v, errors, "unicodeescape", str, bs, i + j, "truncated \\uXXXX");
                continue;
            }
            i += 4;
            v.append((char)x);
        }
        return v.toString();
    }

    public static String PyUnicode_EncodePunycode(PyUnicode input, String errors) {
        int buffer2;
        int n = 128;
        int delta = 0;
        int n2 = 72;
        int n3 = 0;
        StringBuilder bias = new StringBuilder();
        for (int buffer2 : input) {
            if (!Punycode.isBasic(buffer2)) continue;
            bias.appendCodePoint(buffer2);
            ++n3;
        }
        if (n3 > 0) {
            bias.appendCodePoint(45);
        }
        int b = n3;
        buffer2 = input.getCodePointCount();
        while (b < buffer2) {
            int h = Integer.MAX_VALUE;
            int size = 0;
            int m = 0;
            for (int codePointIndex : input) {
                if (codePointIndex > n && codePointIndex < h) {
                    h = codePointIndex;
                    m = size;
                }
                ++size;
            }
            long iter = delta + (h - n) * (b + 1);
            if (iter > Integer.MAX_VALUE) {
                throw Py.UnicodeEncodeError("punycode", input.string, m, m + 1, "overflow");
            }
            delta = (int)iter;
            n = h;
            size = 0;
            for (int codePointIndex : input) {
                if (codePointIndex < n) {
                    iter = delta + 1;
                    if (iter > Integer.MAX_VALUE) {
                        throw Py.UnicodeEncodeError("punycode", input.string, size, size + 1, "overflow");
                    }
                    delta = (int)iter;
                }
                if (codePointIndex == n) {
                    int guard_delta;
                    int q = delta;
                    int k = 36;
                    while (true) {
                        int t;
                        int n4 = k <= guard_delta ? 1 : (t = k >= guard_delta + 26 ? 26 : k - guard_delta);
                        if (q < t) break;
                        bias.appendCodePoint(t + (q - t) % (36 - t));
                        q = (q - t) / (36 - t);
                        k += 36;
                    }
                    bias.appendCodePoint(q);
                    guard_delta = Punycode.adapt(delta, b + 1, b == n3);
                    delta = 0;
                    ++b;
                }
                ++size;
            }
            ++delta;
            ++n;
        }
        return bias.toString();
    }

    public static PyUnicode PyUnicode_DecodePunycode(String input, String errors) {
        int j;
        int input_size = input.length();
        int output_size = 0;
        ArrayList<Integer> ucs4 = new ArrayList<Integer>(input_size);
        for (j = 0; j < input_size; ++j) {
            char c = input.charAt(j);
            if (!Punycode.isBasic(c)) {
                throw Py.UnicodeDecodeError("punycode", input, j, j + 1, "not basic");
            }
            if (c == '-') break;
            ucs4.add(Integer.valueOf(c));
            ++output_size;
        }
        int n = 128;
        int i = 0;
        int bias = 72;
        while (j < input_size) {
            int old_i = i;
            int w = 1;
            int k = 36;
            while (true) {
                int t;
                char c;
                int digit;
                long guard_i;
                if ((guard_i = (long)(i + (digit = (c = input.charAt(j++)) - 48) * w)) > Integer.MAX_VALUE) {
                    throw Py.UnicodeDecodeError("punycode", input, j, j + 1, "overflow");
                }
                i = (int)guard_i;
                int n2 = k <= bias ? 1 : (t = k >= bias + 26 ? 26 : k - bias);
                if (digit < t) break;
                long guard_w = w * 36 - t;
                if (guard_w > Integer.MAX_VALUE) {
                    throw Py.UnicodeDecodeError("punycode", input, j, j + 1, "overflow");
                }
                k += 36;
            }
            bias = Punycode.adapt(i - old_i, output_size + 1, old_i == 0);
            n += i / (output_size + 1);
            ucs4.add(i %= output_size + 1, n);
        }
        return new PyUnicode(ucs4);
    }

    public static String PyUnicode_EncodeIDNA(PyUnicode input, String errors) {
        throw new UnsupportedOperationException();
    }

    public static PyUnicode PyUnicode_DecodeIDNA(String input, String errors) {
        throw new UnsupportedOperationException();
    }

    public static PyObject encoding_error(String errors, String encoding, String toEncode, int start, int end, String reason) {
        PyObject errorHandler = codecs.lookup_error(errors);
        PyException exc = Py.UnicodeEncodeError(encoding, toEncode, start, end, reason);
        exc.normalize();
        PyObject replacement = errorHandler.__call__(new PyObject[]{exc.value});
        codecs.checkErrorHandlerReturn(errors, replacement);
        return replacement;
    }

    public static int insertReplacementAndGetResume(StringBuilder partialDecode, String errors, String encoding, String toDecode, int start, int end, String reason) {
        if (errors != null) {
            if (errors.equals(IGNORE)) {
                return end;
            }
            if (errors.equals(REPLACE)) {
                while (start < end) {
                    partialDecode.appendCodePoint(Py_UNICODE_REPLACEMENT_CHARACTER);
                    ++start;
                }
                return end;
            }
        }
        PyObject replacement = codecs.decoding_error(errors, encoding, toDecode, start, end, reason);
        codecs.checkErrorHandlerReturn(errors, replacement);
        partialDecode.append(replacement.__getitem__(0).toString());
        return codecs.calcNewPosition(toDecode.length(), replacement);
    }

    public static PyObject decoding_error(String errors, String encoding, String toEncode, int start, int end, String reason) {
        PyObject errorHandler = codecs.lookup_error(errors);
        PyException exc = Py.UnicodeDecodeError(encoding, toEncode, start, end, reason);
        exc.normalize();
        return errorHandler.__call__(new PyObject[]{exc.value});
    }

    private static void checkErrorHandlerReturn(String errors, PyObject replacement) {
        if (!(replacement instanceof PyTuple && replacement.__len__() == 2 && replacement.__getitem__(0) instanceof PyBaseString && replacement.__getitem__(1) instanceof PyInteger)) {
            throw new PyException(Py.TypeError, "error_handler " + errors + " must return a tuple of (replacement, new position)");
        }
    }

    static {
        INIT_LOCK = new Object();
        default_encoding = "ascii";
        import_encodings_called = false;
        hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        utf7_special = new char[]{'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0002', '\u0002', '\u0001', '\u0001', '\u0002', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0002', '\u0003', '\u0003', '\u0003', '\u0003', '\u0003', '\u0003', '\u0000', '\u0000', '\u0000', '\u0003', '\u0001', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0003', '\u0003', '\u0003', '\u0003', '\u0000', '\u0003', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0003', '\u0001', '\u0003', '\u0003', '\u0003', '\u0003', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0003', '\u0003', '\u0003', '\u0001', '\u0001'};
        utf8_code_length = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 0, 0};
        hexdigit = "0123456789ABCDEF".toCharArray();
    }

    private static class Punycode {
        private static final int BASE = 36;
        private static final int TMIN = 1;
        private static final int TMAX = 26;
        private static final int SKEW = 38;
        private static final int DAMP = 700;
        private static final int INITIAL_BIAS = 72;
        private static final int INITIAL_N = 128;
        private static final int BASIC = 128;

        private Punycode() {
        }

        private static int adapt(int delta, int numpoints, boolean firsttime) {
            delta = firsttime ? delta / 700 : delta >> 1;
            delta += delta / numpoints;
            int k = 0;
            while (delta > 455) {
                delta /= 35;
                k += 36;
            }
            return k + 36 * delta / (delta + 38);
        }

        private static boolean isBasic(int codePoint) {
            return codePoint < 128;
        }
    }
}

